<?php
include ('get_products.php');
?>
<style>
    :root {
      --background-color: #FFFFFF;
      --background-color-secondary: #F7F9F7;
      --background-color-secondary-opacity: rgba(247, 249, 247, 0.5);

      --main: #1C1962;
      --dark-main: #20331B;
      --active-dark-main: #4ECD65;
      --active-light-main: #B8FBC3;

      --secondary: #FFF0EA;

      --grey-main: #848595;
      --grey-light-main: #F1F0F6;
      --grey-dark-main: #848595;

      --off-white: #F7F9F7;

      --warning-red: #F73D3D;
		
	  --primary-200: #191B3F;
	  --primary-150: #2E286B;
	  --primary-100: #655BC6;
		
	  --neutral-500: #111927;
	  --neutral-400: #1F2A37;
	  --neutral-300: #4D5761;
	  --neutral-200: #6C737F;
	  --neutral-25: #FCFCFD;
		
      --white: #FFFFFF;
	  --red: #EA2222;
    }
	
	.new_checkout__header {
		display: flex;
		align-items: center;
		justify-content: center;
		flex-direction: column;
		gap: .5rem;
		
		padding: 2rem 1rem;
		
		background-color: #F1F0F6;
	}
	
	.header__title {
		font-weight: 700;
		font-size: 3rem;
		color: var(--primary-200);
		text-align: center;
	}
	
	.header__subtitle {
		font-weight: 500;
		font-size: 1rem;
		color: var(--neutral-400);
		text-align: center;
	}
	
	@media screen and (max-width: 675px) {
		.new_checkout__header {
			padding-bottom: 0;
		}
		
		.header__title {
			font-size: 2.125rem;
			line-height: 120%;
		}
	}

  .new_checkout__wrapper {
    width: 100%;

    background-color: #F1F0F6;
  }

  .new_checkout__container {
    display: flex;
    align-items: flex-start;
    gap: 1.25rem;
	order: 1;

    width: 100%;
    max-width: 1300px;
    padding: 2rem 1rem;
    margin-inline: auto;
	  
	box-sizing: border-box;
  }

.product__item {
  display: flex;
  align-items: center;
  justify-content: center;
  flex-direction: column;

  width: 100%;
  padding: 1.5rem 1rem;

  border-radius: .375rem;
  outline: 1px solid var(--neutral-200);
  background: var(--white);

  transition: all ease-in-out .15s;
  box-sizing: border-box;
}

.product__item.is-selected {
  outline: 1px solid var(--primary-100);
  border-color: transparent;
  background: rgb(243,244,246);
  background: linear-gradient(180deg, rgba(177, 211, 148, 0.5) 0%, rgba(243, 244, 246, 1) 65%);
  transform: translatey(-16px);
}
	
	.prodtg_pack1 .info__discount {
		display: none !important;
	}
	
@media screen and (max-width: 675px) {
  .product__item.is-selected {
	transform: translatey(0px) !important;
  }
	
  .prodtg_pack1 {
	order: 3;
  }
}
	
.products__item__title {
  font-weight: 700;
  font-size: 2.125rem;
  color: var(--neutral-500);
  text-align: center;
}
	
.products__item__subtitle {
  font-weight: 600;
  font-size: 1rem;
  color: var(--primary-100);
  text-transform: uppercase;
  text-align: center;
}

.product__item.is-selected .item__order {
  border-color: transparent;
  background-color: var(--red);
  box-shadow: none;
}

.product__item.is-selected .item__order .order__title {
  color: var(--white);
}

.product__item.is-selected .item__order .order__selected {
  width: 24px;
  height: 24px;
}

.item__order.active {
    display: none;
}

.item__order.hidden {
    display: flex;
}

.product__item.is-selected .item__order.active {
    display: flex;
}

.product__item.is-selected .item__order.hidden {
    display: none;
}

.product__item .item__title {
  text-align: center;
  font-size: .875rem;
  font-weight: 500;
<?php if (!function_exists('pll_current_language') || pll_current_language() !== 'sv') { ?>
  text-transform: capitalize;
<?php } ?>
}

.product__item .item_image {
  width: 100%;
  max-width: 256px;
  padding: 2rem 0;
}

.product__item  .item__info {
  text-align: start;
  display: flex;
  flex-direction: column;
  gap: 0.3rem;

  width: 100%;
  margin: 1.75rem 0 1rem 0;
}

.product__item .item__info .info__value {
  font-weight: 700;
  font-size: 2.125rem;
  color: var(--neutral-400);
}

.product__item .item__info .info__amount {
  display: block;
	
  width: 64px;
	
  font-size: 1rem;
  font-weight: 500;
  color: var(--neutral-300);
}

.item__info .info__discount {
  display: flex;
  align-items: center;
  justify-content: center;
	
  width: fit-content;
  height: 28px;
  padding: 0 .5rem;

  border-radius: 99rem;
  background-color: var(--red);
}

.info__discount .discount__title {
  font-weight: 600;
  font-size: .688rem;
  color: var(--neutral-25);
}

.item__info .info__before {
  display: block;
	
  margin-bottom: -.5rem;
	
  font-weight: 500;
  font-size: 1.5rem;
  color: var(--neutral-300);
  text-decoration: line-through;
}

.item__info .info__total {
  font-weight: 500;
  font-size: .875rem;
  color: var(--neutral-200);
}

.item__recommendation {
  display: flex;
  flex-direction: column;
  gap: 0.5rem;

  width: 100%;
  margin-bottom: 1rem;
}

.item__recommendation .recommendation__item {
  display: flex;
  align-items: center;
  gap: .7rem;
}

.item__recommendation .recommendation__item .item__image {
  width: 20px;
  height: 20px;
}

.item__recommendation .recommendation__item .item__title {
  font-size: .875rem;
  font-weight: 500;
  text-align: left;
}

.item__order {
  display: flex;
  align-items: center;
  justify-content: center;
  gap: .5rem;

  width: 100%;
  height: 56px;
  padding: 0 1.5rem;
  margin: .5rem 0;

  border-radius: .5rem;
  border: 1px solid var(--red);
  background-color: var(--white);

  cursor: pointer;
  transition: all ease-in-out .15s;
  animation: fadeIn ease-in-out .15s backwards;
  box-sizing: border-box;
}

.item__order:hover {
  background-color: var(--red);
}

.item__order:active {
  background-color: var(--red);
}

.item__order .order__title {
  font-size: 1rem;
  color: var(--red);
}
	
.item__order .order__icon path {
  fill: var(--red);
}

.product__item .item__cards {
  width: 100%;
  max-width: 128px;
  margin: .5rem auto 0 auto;
}
	
.item__order:hover .order__title {
  color: var(--white);
}
	
.item__order:hover .order__icon path {
  fill: var(--white);
}

.info__price__content {
  display: flex;
  align-items: center;
  justify-content: space-between;
	
  width: 100%;
}
	
.info__price__content .price__content {
  display: flex;
  align-items: center;
  flex-wrap: nowrap;
  gap: .5rem;
}
	
.price__discount {
  display: flex;
  flex-direction: column;
  gap: .25rem;
}
	
.price__discount .discount__save {
  font-weight: 600;
  font-size: .875rem;
  color: var(--red);
}
	
.item__sequre__text {
  display: block;
	
  margin-top: .5rem;
	
  font-weight: 600;
  font-size: .875rem;
  color: var(--neutral-400);
}
	
.item__order__guarantee {
  display: flex;
  align-items: center;
  justify-content: space-around;
	
  width: 100%;
  margin: .75rem 0 .5rem 0;
}
	
.guarantee__item {
  display: flex;
  align-items: center;
  gap: .25rem;
}
	
.guarantee__item__title {
  font-weight: 500;
  font-size: .75rem;
  color: var(--neutral-400);
}

@media screen and (max-width: 675px) {
  .new_checkout__container {
    flex-direction: column;
  }

  .product__item .item_image {
    width: 100%;
    max-width: 208px;
    padding: 1rem 0;
  }

  .product__item {
    padding: 1.25rem 1rem;
  }
}
</style>
<div class="new_checkout__header">
  <span class="header__title"><?php echo pll__('Choose your SlimSure package', 'fitsmartio_en'); ?></span>
  <span class="header__subtitle"><?php echo pll__('Support your energy and well-being with every capsule.', 'fitsmartio_en'); ?></span>
</div>
<section id="products" class="new_checkout__wrapper">
  <div class="new_checkout__container new_checkout__product__container"> <?php while ($products->have_posts()) {
          $products->the_post();
          global $product;
          $product_id = get_the_ID();

          $image = wp_get_attachment_image_src(get_post_thumbnail_id($product_id), 'single-post-thumbnail');

		  if ($is_ab_test) {
			  $attachment_ids = $product->get_gallery_image_ids();

			  $image = wp_get_attachment_image_src( $attachment_ids[0] ?? 0, 'single-post-thumbnail' );
		  }

          $weightloss = get_field('weightloss');
	
		  $title_v5 = get_field('title_v5');
	      $subtitle_v5 = get_field('subtitle_v5');
	      $save_v5 = get_field('save_v5');
	
	      $featured_text_1_v5 = get_field('featured_text_1_v5');
		  $featured_text_2_v5 = get_field('featured_text_2_v5');
		  $featured_text_3_v5 = get_field('featured_text_3_v5');
		  $featured_text_4_v5 = get_field('featured_text_4_v5');
	
		  $money_back_v5 = get_field('money_back_v5');
	      $shipping_cost_v5 = get_field('shipping_cost_v5');

          $post_date = get_the_date('YmdHis');
          $regular_price = $product->get_regular_price();
          $formatted_price = wc_price($regular_price);

          $tagsterms = wp_get_post_terms(get_the_id(), 'product_tag');

          $producttags = '';
          $prodtags = array();
          if (count($tagsterms) > 0) {
              foreach ($tagsterms as $tagterm) {
                  $term_name = $tagterm->name;
                  $prodtags[] = "prodtg_" . strtolower($term_name);
              }
              if (!empty($prodtags)) {
                  $producttags = implode(' ', $prodtags);
              }
          }
          ?>
          <div class="product__item product-block <?php echo $producttags; ?> prdpack_<?php echo $product_id; ?> <?php echo (in_array($product_id, $cart_product)) ? " is-selected " : "" ?> prdpack_<?php echo $product_id; ?>"  data-prdid="<?php echo $product_id; ?>">
              <span class="products__item__title"><?php echo $title_v5; ?></span>
			  <span class="products__item__subtitle"><?php echo $subtitle_v5; ?></span>
              <img class="item_image" src="<?php echo $image[0]; ?>" alt="item_image">
              <div class="item__info">
                  <?php
                      //echo get_field('neu_price_without_fee')
                      $product_price_val = $product->get_price();

                      $regular_price = $product->get_regular_price();
                      $sale_price = $product->get_sale_price();
                  ?>
				<div class="info__price__content">
				  <div class="price__content">
					<?php if(!empty(get_field('pro_packung_price'))){ ?>
					<span class="info__value"><?php echo get_field('pro_packung_price'); ?> <?php echo get_woocommerce_currency_symbol(); ?></span>
					<?php } ?>
					<span class="info__amount"><?php echo pll__('Price per pack', 'fitsmartio_en'); ?></span>
				  </div>
				  <div class="price__discount">
					<div class="info__discount">
                      <span class="discount__title"><?php echo get_field('discount_text'); ?></span>
                    </div>
					<span class="discount__save"><?php echo $save_v5; ?></span>
				  </div>
				</div>
                <?php if(!empty($vorher_price=get_field('vorher_price'))){ ?>
                <span class="info__before"><?php echo $vorher_price; ?> <?php echo get_woocommerce_currency_symbol(); ?></span>
                <?php } ?>
                <span class="info__total"><?php echo pll__('Total price', 'fitsmartio_en'); ?> <?php echo $product_price_val; ?><?php echo get_woocommerce_currency_symbol(); ?></span>
              </div>
              <div class="item__recommendation">
                <div class="recommendation__item">
                  <svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path d="M17.5174 10.1585C17.8174 10.4445 17.8294 10.9185 17.5434 11.2185L10.8764 18.2185C10.8064 18.292 10.7221 18.3506 10.6288 18.3905C10.5355 18.4305 10.435 18.4512 10.3334 18.4512C10.2319 18.4512 10.1314 18.4305 10.0381 18.3905C9.94472 18.3506 9.86047 18.292 9.79042 18.2185L6.45742 14.7185C6.38659 14.6478 6.33062 14.5636 6.29283 14.4709C6.25503 14.3782 6.23617 14.2789 6.23736 14.1788C6.23854 14.0788 6.25975 13.9799 6.29973 13.8882C6.33971 13.7964 6.39765 13.7136 6.47014 13.6445C6.54263 13.5755 6.6282 13.5217 6.72181 13.4863C6.81542 13.4509 6.91518 13.4345 7.01521 13.4382C7.11523 13.442 7.21349 13.4657 7.30421 13.508C7.39493 13.5503 7.47627 13.6103 7.54342 13.6845L10.3334 16.6145L16.4574 10.1845C16.5946 10.0405 16.7833 9.95694 16.982 9.95207C17.1808 9.94719 17.3734 10.0214 17.5174 10.1585Z" fill="#655BC6"/>
				  </svg>
                  <span class="item__title"><?php echo $featured_text_1_v5; ?></span>
                </div>
                <div class="recommendation__item">
                  <svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path d="M17.5174 10.1585C17.8174 10.4445 17.8294 10.9185 17.5434 11.2185L10.8764 18.2185C10.8064 18.292 10.7221 18.3506 10.6288 18.3905C10.5355 18.4305 10.435 18.4512 10.3334 18.4512C10.2319 18.4512 10.1314 18.4305 10.0381 18.3905C9.94472 18.3506 9.86047 18.292 9.79042 18.2185L6.45742 14.7185C6.38659 14.6478 6.33062 14.5636 6.29283 14.4709C6.25503 14.3782 6.23617 14.2789 6.23736 14.1788C6.23854 14.0788 6.25975 13.9799 6.29973 13.8882C6.33971 13.7964 6.39765 13.7136 6.47014 13.6445C6.54263 13.5755 6.6282 13.5217 6.72181 13.4863C6.81542 13.4509 6.91518 13.4345 7.01521 13.4382C7.11523 13.442 7.21349 13.4657 7.30421 13.508C7.39493 13.5503 7.47627 13.6103 7.54342 13.6845L10.3334 16.6145L16.4574 10.1845C16.5946 10.0405 16.7833 9.95694 16.982 9.95207C17.1808 9.94719 17.3734 10.0214 17.5174 10.1585Z" fill="#655BC6"/>
				  </svg>
                  <span class="item__title"><?php echo $featured_text_2_v5; ?></span>
                </div>
				<div class="recommendation__item">
                  <svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path d="M17.5174 10.1585C17.8174 10.4445 17.8294 10.9185 17.5434 11.2185L10.8764 18.2185C10.8064 18.292 10.7221 18.3506 10.6288 18.3905C10.5355 18.4305 10.435 18.4512 10.3334 18.4512C10.2319 18.4512 10.1314 18.4305 10.0381 18.3905C9.94472 18.3506 9.86047 18.292 9.79042 18.2185L6.45742 14.7185C6.38659 14.6478 6.33062 14.5636 6.29283 14.4709C6.25503 14.3782 6.23617 14.2789 6.23736 14.1788C6.23854 14.0788 6.25975 13.9799 6.29973 13.8882C6.33971 13.7964 6.39765 13.7136 6.47014 13.6445C6.54263 13.5755 6.6282 13.5217 6.72181 13.4863C6.81542 13.4509 6.91518 13.4345 7.01521 13.4382C7.11523 13.442 7.21349 13.4657 7.30421 13.508C7.39493 13.5503 7.47627 13.6103 7.54342 13.6845L10.3334 16.6145L16.4574 10.1845C16.5946 10.0405 16.7833 9.95694 16.982 9.95207C17.1808 9.94719 17.3734 10.0214 17.5174 10.1585Z" fill="#655BC6"/>
				  </svg>
                  <span class="item__title"><?php echo $featured_text_3_v5; ?></span>
                </div>
              </div>
              <div class="item__order active">
                <span class="order__title" style="color: #FFFFFF"><?php echo pll__('Selected', 'fitsmartio_en') ?></span>
                <svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
				  <path d="M10.243 17.314L6 13.07L7.414 11.656L10.243 14.484L15.899 8.82703L17.314 10.242L10.243 17.314Z" fill="white"/>
				  <path fill-rule="evenodd" clip-rule="evenodd" d="M1 13C1 6.925 5.925 2 12 2C18.075 2 23 6.925 23 13C23 19.075 18.075 24 12 24C5.925 24 1 19.075 1 13ZM12 22C10.8181 22 9.64778 21.7672 8.55585 21.3149C7.46392 20.8626 6.47177 20.1997 5.63604 19.364C4.80031 18.5282 4.13738 17.5361 3.68508 16.4442C3.23279 15.3522 3 14.1819 3 13C3 11.8181 3.23279 10.6478 3.68508 9.55585C4.13738 8.46392 4.80031 7.47177 5.63604 6.63604C6.47177 5.80031 7.46392 5.13738 8.55585 4.68508C9.64778 4.23279 10.8181 4 12 4C14.3869 4 16.6761 4.94821 18.364 6.63604C20.0518 8.32387 21 10.6131 21 13C21 15.3869 20.0518 17.6761 18.364 19.364C16.6761 21.0518 14.3869 22 12 22Z" fill="white"/>
				</svg>
              </div>
              <div class="item__order hidden">
                <span class="order__title"><?php echo pll__('Buy Now', 'fitsmartio_en') ?></span>
                <svg class="order__icon" width="25" height="25" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg">
				  <path d="M12.5 4.10071L11.09 5.51071L16.67 11.1007H4.5V13.1007H16.67L11.09 18.6907L12.5 20.1007L20.5 12.1007L12.5 4.10071Z" fill="currentColor"/>
				</svg>
              </div>
			  <div class="item__order__guarantee">
				  <div class="guarantee__item">
					  <svg width="16" height="17" viewBox="0 0 16 17" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M13.9997 3.2674H1.99967C1.82286 3.2674 1.65329 3.33763 1.52827 3.46266C1.40325 3.58768 1.33301 3.75725 1.33301 3.93406V13.2674C1.33301 13.4442 1.40325 13.6138 1.52827 13.7388C1.65329 13.8638 1.82286 13.9341 1.99967 13.9341H13.9997C14.1765 13.9341 14.3461 13.8638 14.4711 13.7388C14.5961 13.6138 14.6663 13.4442 14.6663 13.2674V3.93406C14.6663 3.75725 14.5961 3.58768 14.4711 3.46266C14.3461 3.33763 14.1765 3.2674 13.9997 3.2674ZM13.333 10.6007C12.8026 10.6007 12.2939 10.8114 11.9188 11.1865C11.5437 11.5616 11.333 12.0703 11.333 12.6007H4.66634C4.66634 12.0703 4.45563 11.5616 4.08055 11.1865C3.70548 10.8114 3.19677 10.6007 2.66634 10.6007V6.60073C3.19677 6.60073 3.70548 6.39002 4.08055 6.01494C4.45563 5.63987 4.66634 5.13116 4.66634 4.60073H11.333C11.333 5.13116 11.5437 5.63987 11.9188 6.01494C12.2939 6.39002 12.8026 6.60073 13.333 6.60073V10.6007Z" fill="#2E286B"/>
						<path d="M7.99967 5.93402C6.52901 5.93402 5.33301 7.13002 5.33301 8.60069C5.33301 10.0714 6.52901 11.2674 7.99967 11.2674C9.47034 11.2674 10.6663 10.0714 10.6663 8.60069C10.6663 7.13002 9.47034 5.93402 7.99967 5.93402ZM7.99967 9.93402C7.26434 9.93402 6.66634 9.33602 6.66634 8.60069C6.66634 7.86535 7.26434 7.26735 7.99967 7.26735C8.73501 7.26735 9.33301 7.86535 9.33301 8.60069C9.33301 9.33602 8.73501 9.93402 7.99967 9.93402Z" fill="#2E286B"/>
					  </svg>
					  <span class="guarantee__item__title"><?php echo $money_back_v5; ?></span>
				  </div>
				  <div class="guarantee__item">
					  <svg width="16" height="17" viewBox="0 0 16 17" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M12.7663 5.93406C12.65 5.73254 12.4829 5.56498 12.2818 5.44803C12.0806 5.33107 11.8524 5.2688 11.6197 5.2674H9.99967V3.93406C9.99967 3.75725 9.92944 3.58768 9.80441 3.46266C9.67939 3.33763 9.50982 3.2674 9.33301 3.2674H2.66634C2.31272 3.2674 1.97358 3.40787 1.72353 3.65792C1.47348 3.90797 1.33301 4.24711 1.33301 4.60073V11.2674C1.33325 11.5012 1.39497 11.7309 1.51198 11.9333C1.62899 12.1357 1.79718 12.3038 1.99967 12.4207C1.9758 13.0396 2.19875 13.6425 2.61945 14.097C3.04016 14.5515 3.62417 14.8202 4.24301 14.8441C4.86185 14.8679 5.46482 14.645 5.91928 14.2243C6.37375 13.8036 6.64247 13.2196 6.66634 12.6007H8.73301C8.80673 13.1585 9.08065 13.6705 9.50376 14.0414C9.92688 14.4123 10.4704 14.6168 11.033 14.6168C11.5957 14.6168 12.1391 14.4123 12.5623 14.0414C12.9854 13.6705 13.2593 13.1585 13.333 12.6007C13.6866 12.6007 14.0258 12.4603 14.2758 12.2102C14.5259 11.9602 14.6663 11.621 14.6663 11.2674V9.2674C14.6644 9.14589 14.6324 9.02677 14.573 8.92073L12.7663 5.93406ZM9.99967 6.60073H11.6197L12.8197 8.60073H9.99967V6.60073ZM4.33301 13.2674C4.13523 13.2674 3.94189 13.2087 3.77744 13.0989C3.61299 12.989 3.48482 12.8328 3.40913 12.6501C3.33344 12.4674 3.31364 12.2663 3.35222 12.0723C3.39081 11.8783 3.48605 11.7001 3.6259 11.5603C3.76575 11.4204 3.94394 11.3252 4.13792 11.2866C4.3319 11.248 4.53296 11.2678 4.71569 11.3435C4.89842 11.4192 5.0546 11.5474 5.16448 11.7118C5.27436 11.8763 5.33301 12.0696 5.33301 12.2674C5.33301 12.5326 5.22765 12.787 5.04011 12.9745C4.85258 13.162 4.59822 13.2674 4.33301 13.2674ZM10.9997 13.2674C10.8019 13.2674 10.6086 13.2087 10.4441 13.0989C10.2797 12.989 10.1515 12.8328 10.0758 12.6501C10.0001 12.4674 9.9803 12.2663 10.0189 12.0723C10.0575 11.8783 10.1527 11.7001 10.2926 11.5603C10.4324 11.4204 10.6106 11.3252 10.8046 11.2866C10.9986 11.248 11.1996 11.2678 11.3824 11.3435C11.5651 11.4192 11.7213 11.5474 11.8311 11.7118C11.941 11.8763 11.9997 12.0696 11.9997 12.2674C11.9997 12.5326 11.8943 12.787 11.7068 12.9745C11.5192 13.162 11.2649 13.2674 10.9997 13.2674Z" fill="#2E286B"/>
					  </svg>
					  <span class="guarantee__item__title"><?php echo $shipping_cost_v5; ?></span>
				  </div>
			  </div>
			  <span class="item__sequre__text"><?php echo pll__('GUARANTEED SECURE PAYMENT', 'fitsmartio_en') ?></span>
              <img class="item__cards" src="https://fitsmart.io/shop/wp-content/uploads/2024/12/payment_icons.avif" alt="item__cards">
            </div>
      <?php } ?>
  </div>
</section>
