<style>
    .delivery__wrapper {
        width: 100%;
        padding-top: 2rem;
        padding-bottom: 2rem;

        border: 1px solid var(--grey-light-main);
        border-left: none;
        border-right: none;
    }

    .delivery__container {
        display: flex;
        gap: 1rem;
    }

    .delivery__container .delivery__item {
        width: 100%;
        display: flex;
        flex-direction: column;
        gap: .5rem;
    }

    .delivery__item .item__header {
        display: flex;
        align-items: center;
        gap: .3rem;
    }

    .delivery__item .item__header .header__title {
        font-weight: 600;
    }

    .delivery__item .item__subtitle {
        font-weight: 300;
        font-size: 0.9em;
        color: var(--grey-dark-main);
    }

    @media screen and (max-width: 675px) {
        .delivery__container {
            display: flex;
            flex-direction: column;
            gap: 1rem;
        }
    }
</style>
<div class="delivery__wrapper">
    <div class="container delivery__container">
        <div class="delivery__item">
            <div class="item__header">
                <img
                        class="header__image"
                        src="https://glucofit.co/wp-content/uploads/2024/09/earth.svg"
                        alt="header__image"
                >
                <span class="header__title"><?php echo pll__('Free shipping', 'fitsmartio_en'); ?></span>
            </div>
            <span class="item__subtitle"><?php echo pll__('You will receive your order within 3-5 days within the EU', 'fitsmartio_en'); ?></span>
        </div>
        <div class="delivery__item">
            <div class="item__header">
                <img
                        class="header__image"
                        src="https://glucofit.co/wp-content/uploads/2024/09/check.svg"
                        alt="header__image"
                >
                <span class="header__title"><?php echo pll__('60-day money-back guarantee', 'fitsmartio_en'); ?></span>
            </div>
            <span class="item__subtitle">
                <?php echo pll__("Send it back to us for free and get all your money back - we won't ask you any questions", 'fitsmartio_en'); ?>
            </span>
        </div>
        <div class="delivery__item">
            <div class="item__header">
                <img
                        class="header__image"
                        src="https://glucofit.co/wp-content/uploads/2024/09/EU_flag.svg"
                        alt="header__image"
                >
                <span class="header__title"><?php echo pll__('Made in the EU', 'fitsmartio_en'); ?></span>
            </div>
            <span class="item__subtitle">
                <?php echo pll__('Manufactured in an award-winning supplement laboratory in the EU', 'fitsmartio_en'); ?>
            </span>
        </div>
    </div>
</div>
