<?php

add_action('wp_ajax_refresh_checkout_nonces', 'himero_refresh_nonces');
add_action('wp_ajax_nopriv_refresh_checkout_nonces', 'himero_refresh_nonces');
function himero_refresh_nonces()
{
    wp_send_json_success(array(
        'update_order_review' => wp_create_nonce('update-order-review'),
        'process_checkout'    => wp_create_nonce('woocommerce-process_checkout'),
    ));
}

// 2) Подключаем JS только на странице checkout и передаём параметры
add_action('wp_enqueue_scripts', 'himero_enqueue_checkout_assets');
function himero_enqueue_checkout_assets()
{
    if (false === str_contains($_SERVER['REQUEST_URI'], '/checkout')) {
        return;
    }

    // Регистрируем скрипт
    wp_enqueue_script(
        'himero-checkout-fix',
        get_theme_file_uri('/assets/js/checkout-fix.js'),
        array('jquery'),
        '1.1.1',
        true
    );

    wp_localize_script(
        'himero-checkout-fix',
        'CHECKOUT_URL',
        array(
            'ajax_url' => admin_url('admin-ajax.php'),
        )
    );
}
