<?php
/**
 * V5 Footer Section block template.
 *
 * @param array $block The block settings and attributes.
 */

$logo = get_field('logo');
$link = get_field('link');
$text = get_field('text');
?>

<style>
	.footer__wrapper {
	  width: 100%;

	  background: var(--primary-200);
	}
	
	.footer__container {
		display: flex;
		align-items: center;
		justify-content: center;
		flex-direction: column;
		gap: 1.5rem;
		
		width: 100%;
		max-width: 1300px;
		margin: 0 auto;
		padding: 2rem 1rem;
	}
	
	.footer__logo {
		cursor: pointer;
	}
	
	.footer__logo .logo__image {
		height: 82px;
	}
	
	.footer__text {
		font-weight: 500;
		font-size: 1rem;
		color: var(--white);
		text-align: center;
	}
	
	@media screen and (max-width: 675px) {
		.footer__container {
			padding: 1rem;
		}
	}
</style>

<div class="footer__wrapper">
<footer class="footer__container">
	<a href="<?php echo esc_html($link); ?>" class="footer__logo">
      <img class="logo__image" src="<?php echo esc_html($logo); ?>" alt="logo__image">
    </a>
	<span class="footer__text"><?php echo esc_html($text); ?></span>
</footer>
</div>
