<?php
/**
 * V5 Customers Section block template.
 *
 * @param array $block The block settings and attributes.
 */

$rating = get_field('rating');
$title = get_field('title');
$subtitle = get_field('subtitle');

$reviews = get_field('reviews');

$order = get_field('order');
?>

<style>
	.customers__wrapper {
		display: none;
		width: 100%;
		
		background-color: #F1F0F6;
	}
	
	@media screen and (max-width: 675px) {
		.customers__wrapper {
			display: block;			
		}
	}
	
	.customers__conainer {
		display: flex;
		flex-direction: column;
		gap: 2.5rem;
		
		width: 100%;
		max-width: 1300px;
		padding: 5rem 1rem;
		margin: 0 auto;
		
		box-sizing: border-box;
	}
	
	.customers__header {
		display: flex;
		align-items: center;
		justify-content: center;
		flex-direction: column;
	}
	
	.customers__header .header__rating {
		display: flex;
		align-items: center;
		gap: .5rem;
	}
	
	.customers__header .header__rating .rating__stars {
		display: flex;
		align-items: center;
		gap: .15rem;
	}
	
	.customers__header .header__rating .rating__stars .stars__icon {
		width: 18px;
		height: 18px;
	}
	
	.customers__header .header__rating .rating__stars .stars__icon path {
		fill: var(--primary-100);
	}
	
	.customers__header .header__rating .rating__title {
		font-weight: 500;
		font-size: 1rem;
		color: var(--primary-200);
		text-transform: uppercase;
		text-align: center;
	}
	
	.customers__header .header__title {
		font-weight: 700;
		font-size: 2.125rem;
		color: var(--primary-200);
		text-align: center;
	}
	
	.customers__header .header__subtitle {
		font-weight: 500;
		font-size: 1rem;
		color: var(--neutral-400);
		text-align: center;
	}
	
	.customers__story {
		display: flex;
		align-items: flex-start;
		justify-content: center;
		gap: 5rem;
	}
	
	.customers__story .story__item {
		display: flex;
		align-items: flex-start;
		justify-content: flex-start;
		flex-direction: column;
		gap: 1rem;
		
		width: 100%;
	}
	
	.customers__story .story__item .story__item__image {
		width: 100%;
		
		aspect-ratio: 1 / 1;
		object-fit: cover;
	}
	
	.customers__story .story__item .story__item__content {
		display: flex;
		align-items: flex-start;
		justify-content: flex-start;
		flex-direction: column;
		gap: .25rem;
	}
	
	.customers__story .story__item .story__item__content .content__title {
		font-weight: 600;
		font-size: 1rem;
		color: var(--primary-200);
	}
	
	.customers__story .story__item .story__item__content .content__subtitle {
		font-weight: 600;
		font-size: 1rem;
		color: var(--primary-150);
	}
	
	.customers__order {
		display: flex;
		align-items: center;
		justify-content: center;
		gap: .25rem;
		
		width: 100%;
		max-width: 512px;
		height: 64px;
		margin: 0 auto;
		
		border-radius: .5rem;
		background: var(--red);
		
		text-decoration: none;
		
		cursor: pointer;
		transition: all ease-in-out .15s;
	}
	
	.customers__order:hover {
		opacity: .75;
	}
	
	.customers__order span {
		font-weight: 600;
		font-size: 1rem;
		color: var(--white);
	}
	
	@media screen and (max-width: 675px) {
		.customers__story {
			flex-direction: column;
			gap: 2.5rem;
		}
	}
</style>

<div class="customers__wrapper">
	<div class="customers__conainer">
		<div class="customers__header">
			<div class="header__rating">
				<div class="rating__stars">
					<svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"></path>
					</svg>
					<svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"></path>
					</svg>
					<svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"></path>
					</svg>
					<svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"></path>
					</svg>
					<svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"></path>
					</svg>
				</div>
				<span class="rating__title"><?php echo esc_html($rating); ?></span>
			</div>
			<span class="header__title"><?php echo esc_html($title); ?></span>
			<span class="header__subtitle"><?php echo esc_html($subtitle); ?></span>
		</div>
		<div class="customers__story">
			<div class="story__item">
				<img class="story__item__image" src="<?php echo esc_html($reviews['review_1']['image_link']); ?>" alt="">
				<div class="story__item__content">
					<span class="content__title"><?php echo esc_html($reviews['review_1']['title']); ?></span>
					<span class="content__subtitle"><?php echo esc_html($reviews['review_1']['subtitle']); ?></span>
				</div>
			</div>
			<div class="story__item">
				<img class="story__item__image" src="<?php echo esc_html($reviews['review_2']['image_link']); ?>" alt="">
				<div class="story__item__content">
					<span class="content__title"><?php echo esc_html($reviews['review_2']['title']); ?></span>
					<span class="content__subtitle"><?php echo esc_html($reviews['review_2']['subtitle']); ?></span>
				</div>
			</div>
			<div class="story__item">
				<img class="story__item__image" src="<?php echo esc_html($reviews['review_3']['image_link']); ?>" alt="">
				<div class="story__item__content">
					<span class="content__title"><?php echo esc_html($reviews['review_3']['title']); ?></span>
					<span class="content__subtitle"><?php echo esc_html($reviews['review_3']['subtitle']); ?></span>
				</div>
			</div>
		</div>
		<a href="#products" class="customers__order">
			<span><?php echo esc_html($order); ?></span>
			<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
				<path d="M12 4L10.59 5.41L16.17 11H4V13H16.17L10.59 18.59L12 20L20 12L12 4Z" fill="white"/>
			</svg>
		</a>
	</div>
</div>
