<?php

function init_acf_option_pages_from_array(array $option_pages)
{
    if (!function_exists('acf_add_options_page') || !function_exists('acf_add_local_field_group') || !function_exists('acf_add_options_sub_page')) return;

    if (!is_admin()) return;

    foreach ($option_pages as $option_page) {
        match ($option_page['is_sub'] ?? false) {
            false => acf_add_options_page( array(
                'page_title' => $option_page['page_title'],
                'menu_title' => $option_page['menu_title'],
                'menu_slug'  => $option_page['menu_slug'],
                'capability'  => $option_page['capability'] ?? '',
                'parent_slug'  => $option_page['parent_slug'] ?? '',
                'redirect'   => true
            )),
            true => acf_add_options_sub_page([
                'page_title'    => $option_page['page_title'],
                'menu_title'    => $option_page['menu_title'],
                'capability'  => $option_page['capability'] ?? '',
                'parent_slug'   => $option_page['parent_slug']
            ])
        };

        foreach ($option_page['groups'] as $group) {
            acf_add_local_field_group($group);
        }
    }
}

