<?php
/**
 * Email Styles
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/email-styles.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates\Emails
 * @version 9.3.0
 */

if (!defined('ABSPATH')) {
    exit;
}

// Load colors.
$bg_color = get_option('woocommerce_email_background_color');
$body_background_color = get_option('woocommerce_email_body_background_color');
$base_color = get_option('woocommerce_email_base_color');
$text_color = get_option('woocommerce_email_text_color');
$footer_text_color = get_option('woocommerce_email_footer_text_color');

$white_color = "#ffffff";
$black_color = "#000000";

// !important; is a gmail hack to prevent styles being stripped if it doesn't like something.
// body{padding: 0;} ensures proper scale/positioning of the email in the iOS native email app.
?>
    body {
        background-color: <?php echo esc_attr($body_background_color); ?>;
        padding: 0;
        text-align: center;
        font-family: Helvetica, Arial, sans-serif !important;
        font-size: 14px !important;
        color: <?php echo esc_attr($text_color) ?>;
    }

    #outer_wrapper {
        background-color: <?php echo esc_attr($body_background_color); ?>;
    }

    #wrapper {
        margin: 0 auto;
        padding: 70px 0;
        -webkit-text-size-adjust: none !important;
        width: 100%;
        max-width: 600px;
    }

    #template_container {
        box-shadow: 0 1px 4px rgba(0, 0, 0, 0.1) !important;
        background-color: <?php echo esc_attr($base_color); ?>;
<!--        border: 1px solid --><?php //echo esc_attr($text_color); ?><!--;-->
        border-radius: 3px !important;
    }

    #template_header {
        background-color: <?php echo esc_attr($base_color); ?>;
        border-radius: 3px 3px 0 0 !important;
        color: <?php echo esc_attr($text_color); ?>;
        border-bottom: 0;
        font-weight: bold;
        line-height: 100%;
        vertical-align: middle;
        font-family: "Helvetica Neue", Helvetica, Roboto, Arial, sans-serif;
    }

    #template_header h1,
    #template_header h1 a {
        color: <?php echo esc_attr($text_color); ?>;
        background-color: inherit;
    }

    #template_header_image img {
    margin-left: 0;
    margin-right: 0;
    }

    #template_footer td {
    padding: 0;
    border-radius: 6px;
    }

    #template_footer #credit {
    border: 0;
    color: <?php echo esc_attr($footer_text_color); ?>;
    font-family: "Helvetica Neue", Helvetica, Roboto, Arial, sans-serif;
    font-size: 12px;
    line-height: 150%;
    text-align: center;
    padding: 24px 0;
    }

    #template_footer #credit p {
    margin: 0 0 16px;
    }

    #body_content {
    background-color: <?php echo esc_attr($bg_color); ?>;
    }

    #body_content table td {
    padding: 48px 48px 32px;
    }

    #body_content table td td {
    padding: 12px;
    }

    #body_content table td th {
    padding: 12px;
    }

    #body_content td ul.wc-item-meta {
    font-size: small;
    margin: 1em 0 0;
    padding: 0;
    list-style: none;
    }

    #body_content td ul.wc-item-meta li {
    margin: 0.5em 0 0;
    padding: 0;
    }

    #body_content td ul.wc-item-meta li p {
    margin: 0;
    }

    #body_content p {
    margin: 0 0 16px;
    }

    #body_content_inner {
    color: <?php echo esc_attr($text_color); ?>;
    font-family: Helvetica, Arial, sans-serif !important;
    font-size: 14px;
    line-height: 150%;
    text-align: <?php echo is_rtl() ? 'right' : 'left'; ?>;
    }

    .td {
    color: <?php echo esc_attr($text_color); ?>;
    border: 1px solid <?php echo esc_attr($text_color); ?>;
    vertical-align: middle;
    }

    .address {
    padding: 12px;
    color: <?php echo esc_attr($text_color); ?>;
    border: 1px solid <?php echo esc_attr($text_color); ?>;
    }

    .additional-fields {
    padding: 12px 12px 0;
    color: <?php echo esc_attr($text_color); ?>;
    border: 1px solid <?php echo esc_attr($text_color); ?>;
    list-style: none outside;
    }

    tfoot > tr > th, tfoot > tr > td, tfoot {
    color: <?php echo esc_attr($text_color); ?> !important;
    border: 1px solid <?php echo esc_attr($text_color); ?> !important;
    }

    .additional-fields li {
    margin: 0 0 12px 0;
    }

    .text {
    color: <?php echo esc_attr($text_color); ?>;
    font-family: "Helvetica Neue", Helvetica, Roboto, Arial, sans-serif;
    }

    .link {
    color: <?php echo esc_attr($text_color); ?>;
    }

    #header_wrapper {
    padding: 16px 48px;
    display: block;
    }

    #template_footer #credit,
    #template_footer #credit a {
    color: <?php echo esc_attr($text_color); ?>;
    }

    h1 {
    font-family: "Helvetica Neue", Helvetica, Roboto, Arial, sans-serif;
    font-size: 2.5rem;
    font-weight: 300;
    line-height: 150%;
    margin: 0;
    text-align: center;
    text-shadow: 0 1px 0 <?php echo esc_attr($text_color); ?>;
    }

    h2 {
    display: block;
    font-family: "Helvetica Neue", Helvetica, Roboto, Arial, sans-serif;
    font-size: 22px;
    font-weight: 500;
    line-height: 130%;
    padding: 0 0 10px;
    text-align: <?php echo is_rtl() ? 'right' : 'left'; ?>;
    }

    h3 {
    display: block;
    font-family: "Helvetica Neue", Helvetica, Roboto, Arial, sans-serif;
    font-size: 16px;
    font-weight: bold;
    line-height: 130%;
    margin: 16px 0 8px;
    text-align: <?php echo is_rtl() ? 'right' : 'left'; ?>;
    }

    a {
    font-weight: normal;
    text-decoration: underline;
    }

    img {
    border: none;
    display: inline-block;
    font-size: 14px;
    font-weight: bold;
    height: auto;
    outline: none;
    text-decoration: none;
    text-transform: capitalize;
    vertical-align: middle;
    margin-<?php echo is_rtl() ? 'left' : 'right'; ?>: 10px;
    max-width: 100%;
    }

    #details {
    font-size: 14px;
    }

    .thanks_title {
    text-align: left;
    font-size: 32px;
    color: <?php echo esc_attr($text_color) ?>;
    font-weight: 500;
    padding: 0 0 10px;
    }

    .footer_text {
    font-size: 10px;
    color: <?php echo esc_attr($text_color) ?>;
    padding: 30px 0 10px;
    text-align: center;
    }

    .footer_title {
    font-size: 2rem;
    color: <?php echo esc_attr($text_color) ?>;
    text-decoration: none;
    }

    .footer_row {
    text-align: center;
    vertical-align: middle;
    }

    .instagram_link {
    text-decoration: none;
    font-size: 14px;
    font-weight: 600;
    color: <?php echo esc_attr($text_color) ?>;
    }

    /**
    * Media queries are not supported by all email clients, however they do work on modern mobile
    * Gmail clients and can help us achieve better consistency there.
    */
    @media screen and (max-width: 600px) {
    #header_wrapper {
    padding: 27px 36px !important;
    font-size: 24px;
    }

    #body_content table > tbody > tr > td {
    padding: 10px !important;
    }

    #body_content_inner {
    font-size: 10px !important;
    }
    }
<?php
