<?php

include_once(get_stylesheet_directory() . '/includes/base-code/review_functions.php');

$star_html ='<svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
</svg>
';

    $checkout_review = new WP_Query([
        'post_type' => 'checkout_review',
        'posts_per_page' => -1,
        'post_status' => 'publish',
    ]);
?>

<style>
    .reviews__wrapper {
        background-color: #fafafaff;
    }

    .reviews__container {
        display: flex;
        align-items: flex-start;
        flex-direction: column;

        width: 100%;
        max-width: 1080px;
        padding: 1rem;
        margin-inline: auto;
    }

    .reviews__subtitle {
        display: flex;

        font-weight: 500;
        font-size: 1.5rem;
        color: #848595;
    }

    .reviews__title {
        display: flex;

        font-weight: 600;
        font-size: 2rem;
        color: #1c1962;
    }

    .reviews__list {
        display: flex;
        flex-direction: column;
        gap: 1rem;

        width: 100%;
        margin-top: 2rem;
    }

    .reviews__list .list__item {
        display: flex;
        align-items: flex-start;
        justify-content: flex-start;
        flex-direction: column;

        width: 100%;
        padding: 1.5rem;

        border-radius: 1rem;
        border: 1px solid #B7C7B7;
        background-color: #FFFFFF;
    }

    .reviews__list .list__item .item__head {
        display: flex;
        align-items: center;
        justify-content: flex-start;
        gap: 1rem;
    }

    .reviews__list .list__item .item__head .head__image {
        width: 56px;
        height: 56px;

        border-radius: 999px;

        object-fit: cover;
    }

    .reviews__list .list__item .item__head .head__info {
        display: flex;
        flex-direction: column;
        gap: .25rem;
    }

    .reviews__list .list__item .item__head .head__info .info__name {
        font-size: 1.15rem;
    }

    .reviews__list .list__item .item__head .head__info .info__country {
        display: flex;
        align-items: center;
        gap: .25rem;
    }

    .reviews__list .list__item .item__head .head__info .info__country .country__flag {
        width: 24px;
        height: 14px;

        object-fit: cover;
    }

    .reviews__list .list__item .item__head .head__info .info__country .country__nane {
        font-size: 1rem;
    }

    .reviews__list .list__item .item__stars {
        display: flex;
        align-items: center;
        gap: .25rem;

        margin: .5rem 0 1rem 0;
    }

    .reviews__list .list__item .item__stars .stars__icon {
        width: 16px;
        height: 16px;
    }

    .reviews__list .list__item .item__text {
        font-size: 1.05rem;
    }
</style>


    <div class="reviews__wrapper">
        <div class="reviews__container">
            <span class="reviews__subtitle" style="margin-top: 1.5rem"><?php echo pll__('Happy people, real results', 'fitsmartio_en'); ?></span>
            <span class="reviews__title"><?php echo pll__('See for yourself what SlimSure users have to say', 'fitsmartio_en'); ?></span>
            <div class="reviews__list">
                <?php
                if ($checkout_review->have_posts()) :
                while ($checkout_review->have_posts()) : $checkout_review->the_post();
                ?>
                <div class="list__item">
                    <div class="item__head">
                        <img class="head__image" src="<?php echo get_field('avatar')?>" alt="head__image">
                        <div class="head__info">
                            <span class="info__name"><?php echo get_the_title(); ?></span>
                            <div class="info__country">
                                <img class="country__flag" src="<?php echo getFlagUriBySlug(get_field('flag')) ?>" alt="country__flag">
                                <span class="country__nane"><?php echo getCountryBySlug(get_field('flag')) ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="item__stars">
                        <?php printStars(get_field('rating_number'), $star_html);?>
                    </div>
                    <span class="item__text">"<?php echo get_field('rating_text')  ?>"</span>
                </div>
                <?php
                endwhile;
                    wp_reset_postdata();
                endif;
                ?>
            </div>
        </div>
    </div>