<?php
/**
 * V5 Benefits Section block template.
 *
 * @param array $block The block settings and attributes.
 */

$title_1 = get_field('title_1');
$text_1 = get_field('text_1');

$title_2 = get_field('title_2');
$text_2 = get_field('text_2');

$title_3 = get_field('title_3');
$text_3 = get_field('text_3');
?>

<style>
/* Delivery Section */

.delivery__wrapper {
  width: 100%;	
  padding-top: 2rem;
  padding-bottom: 2rem;	

  background: var(--primary-200);
}

.delivery__container {
  display: flex;
  gap: 4rem;

  width: 100%;
  max-width: 1300px;
  padding-inline: 1rem;
  margin: 0 auto;
	
  box-sizing: border-box;
}

.delivery__container .delivery__item {
  width: 100%;
  display: flex;
  flex-direction: column;
  gap: .5rem;
}
	
.delivery__item .item__title {
  font-weight: 600;
  font-size: 1rem;
  color: var(--white);
}

.delivery__item .item__subtitle {
  font-weight: 300;
  font-size: 1rem;
  color: var(--white);
  line-height: 140%;
}

@media screen and (max-width: 675px) {
  .delivery__container {
    display: flex;
    flex-direction: column;
    gap: 2rem;
  }
}
</style>

<div class="delivery__wrapper">
    <div class="container delivery__container">
        <div class="delivery__item">
            <span class="item__title"><?php echo esc_html($title_1); ?></span>
            <span class="item__subtitle"><?php echo esc_html($text_1); ?></span>
        </div>
        <div class="delivery__item">
            <span class="item__title"><?php echo esc_html($title_2); ?></span>
            <span class="item__subtitle"><?php echo esc_html($text_2); ?></span>
        </div>
        <div class="delivery__item">
            <span class="item__title"><?php echo esc_html($title_3); ?></span>
            <span class="item__subtitle"><?php echo esc_html($text_3); ?></span>
        </div>
    </div>
</div>
