<?php
/**
 * Footer Section block template.
 *
 * @param array $block The block settings and attributes.
 */

$logo = get_field('logo');
$link = get_field('link');

$secure = get_field('secure');
$rights = get_field('rights');
$text = get_field('text');

$about = get_field('about');
$support = get_field('support');
$legal = get_field('legal');
?>

<div class="footer__wrapper">
<footer class="footer__container">
     <div class="footer__header">
          <div class="header__blocks">
            <div class="blocks__item">
              <span class="item__title small-title"><?php echo esc_html($about['title']); ?></span>
              <ul class="item__list">
                <li>
                  <a href="<?php echo esc_html($about['use']['link']); ?>">
                    <span class="body-medium"><?php echo esc_html($about['use']['title']); ?></span>
                  </a>
                </li>
                <li>
                  <a href="<?php echo esc_html($about['ingredients']['link']); ?>">
                    <span class="body-medium"><?php echo esc_html($about['ingredients']['title']); ?></span>
                  </a>
                </li>
				<li>
                  <a href="<?php echo esc_html($about['story']['link']); ?>">
                    <span class="body-medium"><?php echo esc_html($about['story']['title']); ?></span>
                  </a>
                </li>
              </ul>
            </div>
            <div class="blocks__item">
              <span class="item__title small-title"><?php echo esc_html($support['title']); ?></span>
              <ul class="item__list">
                <li>
                  <a href="<?php echo esc_html($support['faq']['link']); ?>">
                    <span class="body-medium"><?php echo esc_html($support['faq']['title']); ?></span>
                  </a>
                </li>
                <li>
                  <a href="<?php echo esc_html($support['contact']['link']); ?>">
                    <span class="body-medium"><?php echo esc_html($support['contact']['title']); ?></span>
                  </a>
                </li>
                <li>
                  <a href="<?php echo esc_html($support['shipping']['link']); ?>">
                    <span class="body-medium"><?php echo esc_html($support['shipping']['title']); ?></span>
                  </a>
                </li>
              </ul>
            </div>
            <div class="blocks__item">
              <span class="item__title small-title"><?php echo esc_html($legal['title']); ?></span>
              <ul class="item__list">
                <li>
                  <a href="<?php echo esc_html($legal['terms']['link']); ?>">
                    <span class="body-medium"><?php echo esc_html($legal['terms']['title']); ?></span>
                  </a>
                </li>
                <li>
                  <a href="<?php echo esc_html($legal['protection']['link']); ?>">
                    <span class="body-medium"><?php echo esc_html($legal['protection']['title']); ?></span>
                  </a>
                </li>
                <li>
                  <a href="<?php echo esc_html($legal['return']['link']); ?>">
                    <span class="body-medium"><?php echo esc_html($legal['return']['title']); ?></span>
                  </a>
                </li>
              </ul>
            </div>
          </div>
        </div>
    <div class="footer__company">
      <div class="company__info">
        <div class="info__links">
          <a href="<?php echo esc_html($link); ?>">
            <img class="links__logo" src="<?php echo esc_html($logo); ?>" alt="">
          </a>
<!--           <div class="links__content">
            <a class="content__link" href="https://www.instagram.com/fitsmartco">
              <svg width="21" height="20" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M10.2607 7.52C9.77024 7.52 9.29076 7.66545 8.88293 7.93795C8.47509 8.21046 8.15723 8.59778 7.96952 9.05095C7.78182 9.50411 7.7327 10.0028 7.82839 10.4838C7.92409 10.9649 8.16028 11.4068 8.50712 11.7536C8.85395 12.1005 9.29585 12.3367 9.77692 12.4323C10.258 12.528 10.7566 12.4789 11.2098 12.2912C11.663 12.1035 12.0503 11.7856 12.3228 11.3778C12.5953 10.97 12.7407 10.4905 12.7407 10C12.7407 9.67432 12.6766 9.35183 12.552 9.05095C12.4273 8.75006 12.2447 8.47666 12.0144 8.24638C11.7841 8.01609 11.5107 7.83341 11.2098 7.70878C10.9089 7.58415 10.5864 7.52 10.2607 7.52ZM20.1907 5.07C20.1855 4.29776 20.0433 3.53257 19.7707 2.81C19.57 2.28126 19.2595 1.80109 18.8596 1.40119C18.4596 1.00128 17.9795 0.690718 17.4507 0.49C16.7282 0.217464 15.963 0.0752609 15.1907 0.0699999C13.9007 -6.70552e-08 13.5207 0 10.2607 0C7.00074 0 6.62074 -6.70552e-08 5.33074 0.0699999C4.5585 0.0752609 3.79331 0.217464 3.07074 0.49C2.542 0.690718 2.06184 1.00128 1.66193 1.40119C1.26202 1.80109 0.95146 2.28126 0.750742 2.81C0.478206 3.53257 0.336003 4.29776 0.330742 5.07C0.260742 6.36 0.260742 6.74 0.260742 10C0.260742 13.26 0.260742 13.64 0.330742 14.93C0.341506 15.705 0.483517 16.4725 0.750742 17.2C0.95057 17.7263 1.26087 18.2037 1.66074 18.6C2.05894 19.0023 2.54013 19.3129 3.07074 19.51C3.79331 19.7825 4.5585 19.9247 5.33074 19.93C6.62074 20 7.00074 20 10.2607 20C13.5207 20 13.9007 20 15.1907 19.93C15.963 19.9247 16.7282 19.7825 17.4507 19.51C17.9814 19.3129 18.4625 19.0023 18.8607 18.6C19.2606 18.2037 19.5709 17.7263 19.7707 17.2C20.043 16.4739 20.1852 15.7055 20.1907 14.93C20.2607 13.64 20.2607 13.26 20.2607 10C20.2607 6.74 20.2607 6.36 20.1907 5.07ZM17.6507 13.07C17.6187 13.6871 17.4869 14.295 17.2607 14.87C17.0666 15.3497 16.778 15.7854 16.4121 16.1514C16.0462 16.5173 15.6104 16.8059 15.1307 17C14.5503 17.2136 13.939 17.3318 13.3207 17.35C12.5307 17.35 12.3207 17.35 10.2607 17.35C8.20074 17.35 7.99074 17.35 7.20074 17.35C6.58247 17.3318 5.97123 17.2136 5.39074 17C4.89485 16.8157 4.44702 16.5217 4.08074 16.14C3.71841 15.7813 3.43859 15.3479 3.26074 14.87C3.0463 14.2901 2.93135 13.6782 2.92074 13.06C2.92074 12.27 2.92074 12.06 2.92074 10C2.92074 7.94 2.92074 7.73 2.92074 6.94C2.93135 6.32183 3.0463 5.70988 3.26074 5.13C3.44502 4.6341 3.73902 4.18628 4.12074 3.82C4.48108 3.45962 4.91401 3.18009 5.39074 3C5.97123 2.78641 6.58247 2.66821 7.20074 2.65C7.99074 2.65 8.20074 2.65 10.2607 2.65C12.3207 2.65 12.5307 2.65 13.3207 2.65C13.939 2.66821 14.5503 2.78641 15.1307 3C15.6266 3.18428 16.0745 3.47827 16.4407 3.86C16.8031 4.21875 17.0829 4.65213 17.2607 5.13C17.4743 5.71049 17.5925 6.32173 17.6107 6.94C17.6107 7.73 17.6107 7.94 17.6107 10C17.6107 12.06 17.6807 12.27 17.6507 13.06V13.07ZM16.0507 5.63C15.9317 5.30698 15.744 5.01364 15.5005 4.77021C15.2571 4.52678 14.9638 4.33906 14.6407 4.22C14.1972 4.06626 13.7301 3.99179 13.2607 4C12.4807 4 12.2607 4 10.2607 4C8.26074 4 8.04074 4 7.26074 4C6.78901 4.00461 6.32181 4.09263 5.88074 4.26C5.56267 4.37366 5.27244 4.55371 5.02933 4.7882C4.78622 5.02269 4.5958 5.30624 4.47074 5.62C4.32552 6.06537 4.25457 6.5316 4.26074 7C4.26074 7.78 4.26074 8 4.26074 10C4.26074 12 4.26074 12.22 4.26074 13C4.27066 13.4712 4.35851 13.9375 4.52074 14.38C4.63981 14.703 4.82753 14.9964 5.07096 15.2398C5.31438 15.4832 5.60773 15.6709 5.93074 15.79C6.35741 15.9469 6.8064 16.0347 7.26074 16.05C8.04074 16.05 8.26074 16.05 10.2607 16.05C12.2607 16.05 12.4807 16.05 13.2607 16.05C13.7325 16.0454 14.1997 15.9574 14.6407 15.79C14.9638 15.6709 15.2571 15.4832 15.5005 15.2398C15.744 14.9964 15.9317 14.703 16.0507 14.38C16.2181 13.9389 16.3061 13.4717 16.3107 13C16.3107 12.22 16.3107 12 16.3107 10C16.3107 8 16.3107 7.78 16.3107 7C16.311 6.5278 16.2228 6.05972 16.0507 5.62V5.63ZM10.2607 13.82C9.75956 13.82 9.26331 13.7211 8.8004 13.529C8.3375 13.3369 7.91705 13.0554 7.56312 12.7005C7.2092 12.3457 6.92877 11.9245 6.73789 11.4611C6.54701 10.9977 6.44943 10.5012 6.45074 10C6.45074 9.24405 6.67504 8.5051 7.09523 7.87669C7.51542 7.24828 8.11261 6.75866 8.81121 6.46983C9.50981 6.181 10.2784 6.10594 11.0197 6.25415C11.761 6.40236 12.4416 6.76717 12.9754 7.30241C13.5093 7.83764 13.8723 8.51924 14.0186 9.2609C14.1648 10.0026 14.0877 10.771 13.7971 11.4688C13.5064 12.1666 13.0152 12.7625 12.3857 13.1811C11.7562 13.5996 11.0167 13.822 10.2607 13.82ZM14.2607 6.93C14.0397 6.9066 13.8351 6.80222 13.6864 6.63697C13.5377 6.47172 13.4555 6.25729 13.4555 6.035C13.4555 5.81271 13.5377 5.59828 13.6864 5.43303C13.8351 5.26778 14.0397 5.1634 14.2607 5.14C14.4818 5.1634 14.6864 5.26778 14.8351 5.43303C14.9837 5.59828 15.066 5.81271 15.066 6.035C15.066 6.25729 14.9837 6.47172 14.8351 6.63697C14.6864 6.80222 14.4818 6.9066 14.2607 6.93Z" fill="currentColor"/>
              </svg>
            </a>
            <a class="content__link" href="https://www.tiktok.com/@fitsmartco">
              <svg width="21" height="20" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M19.2607 0H1.26074C0.995526 0 0.741172 0.105357 0.553635 0.292893C0.366099 0.48043 0.260742 0.734784 0.260742 1V19C0.260742 19.2652 0.366099 19.5196 0.553635 19.7071C0.741172 19.8946 0.995526 20 1.26074 20H19.2607C19.526 20 19.7803 19.8946 19.9678 19.7071C20.1554 19.5196 20.2607 19.2652 20.2607 19V1C20.2607 0.734784 20.1554 0.48043 19.9678 0.292893C19.7803 0.105357 19.526 0 19.2607 0ZM15.9797 8.725C15.8707 8.73565 15.7613 8.74132 15.6517 8.742C15.0584 8.74277 14.4743 8.59571 13.9521 8.31409C13.4299 8.03246 12.9861 7.62517 12.6607 7.129V12.622C12.6609 13.4253 12.4229 14.2106 11.9768 14.8785C11.5306 15.5465 10.8964 16.0672 10.1543 16.3747C9.41219 16.6822 8.59558 16.7627 7.80773 16.606C7.01988 16.4494 6.29618 16.0626 5.72818 15.4946C5.16018 14.9266 4.77339 14.2029 4.61672 13.415C4.46006 12.6272 4.54057 11.8106 4.84806 11.0685C5.15555 10.3264 5.67621 9.69214 6.3442 9.24599C7.01218 8.79983 7.79747 8.5618 8.60074 8.562C8.68574 8.562 8.76774 8.57 8.85174 8.575V10.575C8.57196 10.5411 8.28821 10.5648 8.01791 10.6446C7.74762 10.7244 7.4965 10.8586 7.27999 11.039C7.06348 11.2194 6.88615 11.4422 6.7589 11.6937C6.63164 11.9451 6.55716 12.22 6.54002 12.5013C6.52287 12.7826 6.56344 13.0644 6.65922 13.3295C6.755 13.5945 6.90396 13.8372 7.09697 14.0426C7.28997 14.2479 7.52293 14.4116 7.78153 14.5237C8.04014 14.6357 8.31892 14.6937 8.60074 14.694C9.15691 14.7041 9.69481 14.4954 10.0988 14.113C10.5027 13.7306 10.7404 13.2049 10.7607 12.649L10.7807 3.318H12.6947C12.7821 4.14945 13.159 4.92372 13.7595 5.5054C14.36 6.08708 15.1459 6.43913 15.9797 6.5V8.725Z" fill="currentColor"/>
              </svg>
            </a>
            <a class="content__link" href="http://fb.com/getfitsmart.io">
              <svg width="21" height="20" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M19.1607 0H1.36074C1.069 0 0.789215 0.115893 0.582925 0.322183C0.376635 0.528473 0.260742 0.808262 0.260742 1.1V18.9C0.260742 19.0445 0.289195 19.1875 0.344475 19.321C0.399755 19.4544 0.48078 19.5757 0.582925 19.6778C0.685069 19.78 0.806332 19.861 0.93979 19.9163C1.07325 19.9715 1.21629 20 1.36074 20H10.9407V12.25H8.34074V9.25H10.9407V7C10.8869 6.47176 10.9492 5.93813 11.1235 5.43654C11.2977 4.93495 11.5795 4.47755 11.9492 4.09641C12.3189 3.71528 12.7675 3.41964 13.2636 3.23024C13.7596 3.04083 14.2911 2.96225 14.8207 3C15.5991 2.99521 16.377 3.03528 17.1507 3.12V5.82H15.5607C14.3007 5.82 14.0607 6.42 14.0607 7.29V9.22H17.0607L16.6707 12.22H14.0607V20H19.1607C19.3052 20 19.4482 19.9715 19.5817 19.9163C19.7152 19.861 19.8364 19.78 19.9386 19.6778C20.0407 19.5757 20.1217 19.4544 20.177 19.321C20.2323 19.1875 20.2607 19.0445 20.2607 18.9V1.1C20.2607 0.955546 20.2323 0.812506 20.177 0.679048C20.1217 0.54559 20.0407 0.424327 19.9386 0.322183C19.8364 0.220038 19.7152 0.139013 19.5817 0.0837326C19.4482 0.0284524 19.3052 0 19.1607 0Z" fill="currentColor"/>
              </svg>
            </a>
          </div> -->
        </div>
        <div class="info__secure">
          <svg class="secure__icon" width="10" height="12" viewBox="0 0 10 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M1.14286 12C0.828571 12 0.559524 11.8881 0.335714 11.6643C0.111905 11.4405 0 11.1714 0 10.8571V5.14286C0 4.82857 0.111905 4.55952 0.335714 4.33571C0.559524 4.11191 0.828571 4 1.14286 4H1.71429V2.85714C1.71429 2.06667 1.99286 1.39286 2.55 0.835714C3.10714 0.278571 3.78095 0 4.57143 0C5.36191 0 6.03571 0.278571 6.59286 0.835714C7.15 1.39286 7.42857 2.06667 7.42857 2.85714V4H8C8.31429 4 8.58333 4.11191 8.80714 4.33571C9.03095 4.55952 9.14286 4.82857 9.14286 5.14286V10.8571C9.14286 11.1714 9.03095 11.4405 8.80714 11.6643C8.58333 11.8881 8.31429 12 8 12H1.14286ZM1.14286 10.8571H8V5.14286H1.14286V10.8571ZM4.57143 9.14286C4.88571 9.14286 5.15476 9.03095 5.37857 8.80714C5.60238 8.58333 5.71429 8.31429 5.71429 8C5.71429 7.68571 5.60238 7.41667 5.37857 7.19286C5.15476 6.96905 4.88571 6.85714 4.57143 6.85714C4.25714 6.85714 3.9881 6.96905 3.76429 7.19286C3.54048 7.41667 3.42857 7.68571 3.42857 8C3.42857 8.31429 3.54048 8.58333 3.76429 8.80714C3.9881 9.03095 4.25714 9.14286 4.57143 9.14286ZM2.85714 4H6.28571V2.85714C6.28571 2.38095 6.11905 1.97619 5.78571 1.64286C5.45238 1.30952 5.04762 1.14286 4.57143 1.14286C4.09524 1.14286 3.69048 1.30952 3.35714 1.64286C3.02381 1.97619 2.85714 2.38095 2.85714 2.85714V4Z" fill="currentColor"/>
          </svg>
          <span class="secure__text"><?php echo esc_html($secure); ?></span>
        </div>
      </div>
      <span class="company__rights"><?php echo esc_html($rights); ?></span>
    </div>
    <span class="footer__text"><?php echo esc_html($text); ?></span>
</footer>
</div>
