document.addEventListener("contextmenu", (e) => e.preventDefault());
document.addEventListener("keydown", function (e) {
    if (e.ctrlKey && (e.key === "u" || e.key === "s" || e.key === "J" || e.key === "C")) {
        e.preventDefault();
    }
});

window.onfocus = (e) => {
    document.body.classList.remove("blurred");
}

window.onblur = (e) => {
    document.body.classList.add("blurred");
}

document.addEventListener("keydown", function (e) {
    if (e.key === "PrintScreen") {
        document.body.classList.add("blurred");
        return false;
    }
    if (e.ctrlKey && e.shiftKey) {
        document.body.classList.add("blurred");
        return false;
    }
    if (e.metaKey & e.shiftKey) {
        document.body.classList.add("blurred");
        return false;
    }
});

let removeBlurTimeout = null;

document.addEventListener("keyup", function (e) {
    if (e.key === "PrintScreen") {
        if (removeBlurTimeout) {
            clearTimeout(removeBlurTimeout);
        }

        removeBlurTimeout = setTimeout(() => {
            document.body.classList.remove("blurred");
        }, 3000)
        return false;
    }

    if (!e.ctrlKey && !e.shiftKey) {
        if (removeBlurTimeout) {
            clearTimeout(removeBlurTimeout);
        }

        removeBlurTimeout = setTimeout(() => {
            document.body.classList.remove("blurred");
        }, 3000)
        return false;
    }

    if (!e.metaKey & !e.shiftKey) {
        if (removeBlurTimeout) {
            clearTimeout(removeBlurTimeout);
        }

        removeBlurTimeout = setTimeout(() => {
            document.body.classList.remove("blurred");
        }, 3000)
        return false;
    }
})