<?php
/**
 * Thank You Section block template.
 *
 * @param array $block The block settings and attributes.
 */

$h2 = get_field('h2');
$span = get_field('span');
?>

<style>
  .thank_section {
	display: flex;
	align-items: center;
	justify-content: center;
	flex-direction: column;
	  
	width: 100%;
	height: calc(100vh - 72px);
	padding: 0 1rem;  
	  
	background: #ffffff;
  }
	
  .thank_section .thank_title {
	margin-bottom: .75rem;  
	  
    font-size: 4rem;
	color: #ED755B;
	text-align: center;
	line-height: 100%;
  }
	
  .thank_section .thank_text {
    font-size: 2rem;	
	color: #4B294D;
	text-align: center;
  }
	
  @media screen and (max-width: 675px) {
	.thank_section .thank_title {
	  font-size: 2.5rem;
	}
	  
	.thank_section .thank_text {
	  font-size: 1.5rem;  
    }
  }
</style>

<section class="thank_section">
  <h2 class="thank_title"><?php echo esc_html($h2); ?></h2>
  <span class="thank_text"><?php echo esc_html($span); ?></span>
</section>
