<?php

add_action('admin_init', function () {
	$strings = [
		'Woocommerce Email' => [
			'hi' => 'Hi %s,',
			'finished_processing_order' => 'We have finished processing your order',
			'order_has_been_created_for_you' => 'An order has been created for you on %1$s. Your invoice is below, with a link to make payment when you’re ready: %2$s',
			'pay_for_this_order' => 'Pay for this order',
			'here_are_details' => 'Here are the details of your order placed on %s:',
			'billing_address' => 'Billing address',
			'na' => 'N/A',
			'shipping_address' => 'Shipping address',
			'customer_details' => 'Customer details',
			'you_recieve_this' => 'You receive this email since you recently made a purchase.',
			'thanks_for_shopping' => 'Thanks for shopping with us.',
			'product' => 'Product',
			'quantity' => 'Quantity',
			'price' => 'Price',
			'order' => '[Order #%s]',
			'total' => 'Total:',
			'subtotal' => 'Subtotal:',
			'payment_method' => 'Payment method:',
			'order_number' => 'Order Number',
			'tracking_number' => 'Tracking Number',
			'carrier' => 'Carrier',
			'status' => 'Status',
			'track' => 'Track',
			'pending' => 'Pending'
		]
	];

	foreach ($strings as $group => $value) {
		foreach ($value as $name => $string) {
			pll_register_string($name, $string, $group);
		}
	}
});

function polylang_support_legacy( $translated_text, $text, $domain ) {
	if ($domain == 'parcelpanel') {
		return pll__($text);
	}

	return $translated_text;
}
add_filter( 'gettext', 'polylang_support_legacy', 20, 3 );
