<?php

add_action('admin_init', function () {
	$strings = [
		'Woocommerce Email' => [
			'hi' => 'Hi %s,',
			'finished_processing_order' => 'We have finished processing your order.',
			'order_has_been_created_for_you' => 'An order has been created for you on %1$s. Your invoice is below, with a link to make payment when you’re ready: %2$s',
			'pay_for_this_order' => 'Pay for this order',
			'here_are_details' => 'Here are the details of your order placed on %s:',
			'billing_address' => 'Billing address',
			'na' => 'N/A',
			'shipping_address' => 'Shipping address',
			'customer_details' => 'Customer details',
			'you_recieve_this' => 'You receive this email since you recently made a purchase.',
			'thanks_for_shopping' => 'Thanks for shopping with us.',
			'product' => 'Product',
			'quantity' => 'Quantity',
			'price' => 'Price',
			'order' => '[Order #%s]',
			'total' => 'Total:',
			'subtotal' => 'Subtotal:',
			'payment_method' => 'Payment method:',
		],
		'Parcel Panel' => [
			'order_number' => 'Order Number',
			'tracking_number' => 'Tracking Number',
			'carrier' => 'Carrier',
			'status' => 'Status',
			'track' => 'Track',
			'pending' => 'Pending',
			'track_your_order' => 'Track Your Order'
		]
	];

	foreach ($strings as $group => $value) {
		foreach ($value as $name => $string) {
			pll_register_string($name, $string, $group);
		}
	}
});

function polylang_support_legacy( $translated_text, $text, $domain ) {
	if ($domain == 'parcelpanel') {
		return pll__($text);
	}

	return $translated_text;
}
add_filter( 'gettext', 'polylang_support_legacy', 20, 3 );

if (defined('ParcelPanel\OptionName\TRACKING_PAGE_NEW_OPTIONS')) {
	add_filter('option_' . \ParcelPanel\OptionName\TRACKING_PAGE_NEW_OPTIONS, function ($settings) {
		if (!function_exists('pll_current_language')) {
			return $settings;
		}

		$current_lang = pll_current_language();
		$default_lang = pll_default_language();

		// Если не язык по умолчанию, применяем переводы
		if ($current_lang !== $default_lang && !empty($settings)) {

			// Переводим основные элементы интерфейса отслеживания
			$translations_map = [
				'order_number' => 'Order Number',
				'tracking_number' => 'Tracking Number',
				'carrier' => 'Carrier',
				'status' => 'Status',
				'track' => 'Track',
				'delivered' => 'Delivered',
				'in_transit' => 'In Transit',
				'pending' => 'Pending',
				'exception' => 'Exception',
			];

			// Применяем переводы к настройкам
			if (isset($settings['data']['tracking_page_translations'])) {
				foreach ($translations_map as $key => $default_text) {
					if (isset($settings['data']['tracking_page_translations'][$key])) {
						$translated = pll__($default_text);
						if ($translated !== $default_text) {
							$settings['data']['tracking_page_translations'][$key] = $translated;
						}
					}
				}
			}

			// Переводим другие текстовые элементы
			if (isset($settings['page_title'])) {
				$settings['page_title'] = pll__($settings['page_title']);
			}

			if (isset($settings['search_placeholder'])) {
				$settings['search_placeholder'] = pll__($settings['search_placeholder']);
			}
		}

		return $settings;
	});

	add_filter('esc_html', function ($safeText, $text) {
		if ( str_contains( $text, 'Track Your Order' ) ) {
			return pll__('Track Your Order');
		}

		return $text;
	}, 10, 2);
}
