<style>
    .ingredients__wrapper {
        width: 100%;
        padding-top: 2rem;
        padding-bottom: 2rem;

        border-top: 1px solid var(--grey-light-main);
    }

    .ingredients__header {
        display: flex;
        align-items: center;
        justify-content: center;

        width: 100%;
        margin-bottom: 2rem;
    }

    .ingredients__header .header__title {
        font-weight: 600;
        font-size: 2.25em;
    }

    .ingredients__container {
        display: flex;
        gap: 1.5rem;
    }

    .ingredients__container .ingredients__item {
        width: 100%;
        display: flex;
        flex-direction: column;
        gap: 1rem;
    }

    .ingredients__item .item__image {
        width: 100%;
        height: 196px;

        border-radius: .5rem;
        background-color: #868585;

        object-fit: cover;
    }

    .ingredients__item .item__title {
        font-weight: 600;
        font-size: 1.25em;
    }

    .ingredients__item .item__subtitle {
        font-weight: 300;
        font-size: 0.9em;
        color: var(--grey-dark-main);
    }

    @media screen and (max-width: 675px) {
        .ingredients__container {
            display: flex;
            flex-direction: column;
            gap: 1rem;
        }
    }
</style>

<div class="ingredients__wrapper">
    <div class="container ingredients__header">
        <span class="header__title"><?php echo __('Ingredients', 'fitsmartio_en'); ?></span>
    </div>
    <div class="container ingredients__container">
        <div class="ingredients__item">
            <img class="item__image" src="https://images.unsplash.com/photo-1523473827533-2a64d0d36748?q=80&w=3062&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D" alt="">
            <span class="item__title"><?php echo __('Calcium', 'fitsmartio_en'); ?></span>
            <span class="item__subtitle"><?php echo __('An essential mineral for healthy bones and teeth. Important for muscle and nerve function', 'fitsmartio_en'); ?></span>
        </div>
        <div class="ingredients__item">
            <img class="item__image" src="https://images.unsplash.com/photo-1662982689227-0791c9107172?q=80&w=3348&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D" alt="">
            <span class="item__title"><?php echo __('Berberine', 'fitsmartio_en'); ?></span>
            <span class="item__subtitle"><?php echo __('Alkaloid that helps control sugar and cholesterol levels', 'fitsmartio_en'); ?></span>
        </div>
        <div class="ingredients__item">
            <img class="item__image" src="https://images.unsplash.com/photo-1622798662424-f2e4f3098fdf?q=80&w=3386&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D" alt="">
            <span class="item__title"><?php echo __('Cinnamon', 'fitsmartio_en'); ?></span>
            <span class="item__subtitle"><?php echo __('Stabilizes blood sugar levels and has antioxidant properties', 'fitsmartio_en'); ?></span>
        </div>
    </div>
</div>



