<?php
global $woocommerce;
$cart_product = [];
$cart = $woocommerce?->cart?->get_cart() ?? [];

foreach ($cart as $cart_item_key => $cart_item) {
    array_push($cart_product, $cart_item['product_id']);
    $current_product = $cart_item['product_id'];
}
// taxonomy of products with "Variation 2" category
$terms = match (get_language_shortcode()) {
    'en' => 34,
    'fr' => 58,
    'de' => 132,
    'sv' => 143,
    'fi' => 144,
    'da' => 145,
    default => 34,
};

$tax_array = [
    [
        'taxonomy' => 'product_cat',
        'field' => 'term_id',
        'terms' => $terms,
        'operator' => 'NOT IN' // Exclude posts from this category
    ]
];

if (get_query_var("variation") == 'v2') {
    $tax_array = [
        [
            'taxonomy' => 'product_cat',
            'field' => 'term_id',
            'terms' => $terms,
        ]
    ];
}

$args = [
    'post_type' => 'product',
    'posts_per_page' => -1,
    'orderby' => 'publish_date',
    'order' => 'DESC',
    'tax_query' => $tax_array
];
$products = new WP_Query($args);