<?php
require_once ('get_products.php');
?>
<style>
  .new_checkout__wrapper {
    width: 100%;
    background-color: #ffffff;
  }

  .product-block-inner {
    border: none;

    cursor: pointer;
  }

  .new_checkout__container {
    width: 100%;
    /* max-width: 1024px; */
    margin-inline: auto;
  }

  .new_checkout__container.new_checkout__product__container {
    display: flex;
    align-items: center;
    gap: 2rem;
  }

  .new_checkout__product {
    display: flex;
    align-items: center;
    justify-content: center;
    flex-direction: column;

	width: 100%;
    padding: 1.5rem;

    border-radius: 6px;
    border: 1px solid rgb(216, 220, 230);
  }

  .new_checkout__product .product__title {
    margin-bottom: 1rem;

    font-family: sans-serif;
    font-weight: 700;
    font-size: 1.75rem;
  }

  .new_checkout__product .product__image {
    height: 256px;
  }

  .product__info {
    display: flex;
    align-items: center;
    justify-content: space-between;

    width: 100%;
    margin: 1rem 0;
  }

  .info__amount {
    font-family: sans-serif;
    font-weight: 500;
    font-size: 1.5rem;

    white-space: nowrap;
  }

  .info__price {
    display: flex;
    flex-direction: column;

    width: 100%;
  }

  .price__after {
    font-family: sans-serif;
    font-weight: 500;
    font-size: 1.75rem;
  }

  .price__before {
    font-family: sans-serif;
    font-weight: 400;
    font-size: 1rem;

    text-decoration: line-through;
    opacity: .5;
  }

  .price__total {
    margin-top: .5rem;

    font-family: sans-serif;
    font-weight: 400;
    font-size: 1.15rem;

    opacity: .5;
  }

  .product__benefits {
    display: flex;
    flex-direction: column;
    gap: .5rem;

    width: 100%;
	height: 86px;
  }

  .benefits__item {
    display: flex;
    align-items: center;
    gap: .5rem;
  }

  .product__order {
    display: flex;
    align-items: center;
    justify-content: center;

    width: 100%;
    height: 48px;
    margin-top: 2rem;
    margin-bottom: 1rem;

    border-radius: 999px;
    border: 1px solid #20bf8d;
    background-color: #20bf8d;
    color: #ffffff !important;

    cursor: pointer;
    transition: all ease-in-out .15s;
  }

  .product__order:hover {
    background-color: rgb(32, 191, 141, 0.5);
    color: #1c795d !important;
  }

  .order__title {
    font-family: sans-serif;
    font-weight: 500;
    font-size: 1.25rem;
    color: #ffffff !important;

    transition: all ease-in-out .15s;
  }

  .product__order:hover .order__title {
    color: #1c795d !important;
  }

  .product__payment {
    width: 128px;
    margin-top: 1rem;
  }

  .new_checkout__product.is-selected {
    border: 2px solid #20bf8d;
  }

  .new_checkout__product.is-selected .product__order {
    border-color: rgb(32, 191, 141, 0.5);
    background-color: rgb(32, 191, 141, 0.5);
    color: #1c795d !important;
  }

  .new_checkout__product.is-selected .product__order .order__title {
    color: #1c795d !important;
  }
	
  .product_buy_button {
	width: 100%;
  }

  @media screen and (max-width: 675px) {
    .new_checkout__container.new_checkout__product__container {
      flex-direction: column;
    }

    .product__order {
      margin-top: 1.5rem;
      margin-bottom: .5rem;
    }
  }
</style>
<section class="new_checkout__wrapper">
  <div class="new_checkout__container new_checkout__product__container"> <?php while ($products->have_posts()) {
          $products->the_post();
          global $product;
          $product_id = get_the_ID();

          $image = wp_get_attachment_image_src(get_post_thumbnail_id($product_id), 'single-post-thumbnail');
          $weightloss = get_field('weightloss');

          $post_date = get_the_date('YmdHis');
          $regular_price = $product->get_regular_price();
          $formatted_price = wc_price($regular_price);

          $tagsterms = wp_get_post_terms(get_the_id(), 'product_tag');

          $producttags = '';
          $prodtags = array();
          if (count($tagsterms) > 0) {
              foreach ($tagsterms as $tagterm) {
                  $term_name = $tagterm->name;
                  $prodtags[] = "prodtg_" . strtolower($term_name);
              }
              if (!empty($prodtags)) {
                  $producttags = implode(' ', $prodtags);
              }
          }
          ?>
      <div
        class="new_checkout__product product-block-inner <?php echo $producttags; ?> <?php echo (in_array($product_id, $cart_product)) ? " is-selected " : "" ?> prdpack_<?php echo $product_id; ?>"
        data-pack-id="<?php echo $product_id; ?>" data-orderno="<?php echo $post_date ?>"
        id="product_<?php echo $product_id; ?>" data-prdid="<?php echo $product_id; ?>"
        style="order: <?php if ($product_id === 1314 || $product_id === 1372 || $product_id === 1432) echo 1 ?> <?php if ($product_id === 1313 || $product_id === 1370 || $product_id === 2514) echo 2 ?> <?php if ($product_id === 1315 || $product_id === 1373 || $product_id === 1433) echo 3 ?>"
      >
        <span class="product__title"><?php echo get_field('tooltip_text'); ?></span>
        <img class="product__image" src="<?php echo $image[0]; ?>" alt="">
        <div class="product__info">
          <div class="info__price">
              <?php
                //echo get_field('neu_price_without_fee')
                $product_price_val = $product->get_price();

                $regular_price = $product->get_regular_price();
                $sale_price = $product->get_sale_price();
              ?>
            <span class="price__after">
                <?php if(!empty(get_field('pro_packung_price'))){ ?>
                <?php echo get_field('pro_packung_price'); ?><?php echo get_woocommerce_currency_symbol(); ?>
                <?php } ?>‎
            </span>
              <?php if(!empty($vorher_price=get_field('vorher_price'))){ ?>
            <span class="price__before"><?php echo $vorher_price; ?> <?php echo get_woocommerce_currency_symbol(); ?></span>
            <?php } ?>
            <span class="price__total"><?php echo __('Total price', 'fitsmartio_en'); ?> <?php echo $product_price_val; ?><?php echo get_woocommerce_currency_symbol(); ?></span>
          </div>
          <span class="info__amount"><?php echo get_the_title(); ?></span>
        </div>
        <div class="product__benefits">
          <div class="benefits__item">
            <svg xmlns="http://www.w3.org/2000/svg" height="24" width="24" viewBox="0 0 512 512">
              <path d="M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM369 209c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-111 111-47-47c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l64 64c9.4 9.4 24.6 9.4 33.9 0L369 209z"></path>
            </svg>
            <span><?php echo get_field('featured_text2'); ?></span>
          </div>
          <div class="benefits__item">
            <svg xmlns="http://www.w3.org/2000/svg" height="24" width="24" viewBox="0 0 512 512">
              <path d="M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM369 209c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-111 111-47-47c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l64 64c9.4 9.4 24.6 9.4 33.9 0L369 209z"></path>
            </svg>
            <span><?php echo get_field('featured_text3'); ?></span>
          </div>
        </div>
          <div class="product-link product_buy_button">
            <a href="javascript:void(0);" alt="product-link" class="product__order">
              <?php
                $button_label = (in_array($product_id, $cart_product)) ? __('CHOSEN', 'fitsmartio_en') : __('CHOOSE', 'fitsmartio_en');
              ?>
              <span class="order__title"><?php echo $button_label; ?></span>
            </a>
          </div>
        <img class="product__payment" src="https://glucofit.co/wp-content/uploads/2024/08/w320.avif" alt="cards_img">
      </div> <?php } ?>
  </div>
</section>
