<?php
include ('get_products.php');
?>
<style>
    /* Product Container */

    .product__container {
        display: flex;
        flex-direction: row;
        justify-content: space-between;
        gap: 1.5rem;

        margin-top: 2rem;
        margin-bottom: 2rem;
        scroll-margin-top: 2rem;
    }

    .product__item {
        display: flex;
        align-items: center;
        justify-content: center;
        flex-direction: column;

        width: 100%;
        padding: 2.5rem 1.5rem;

        border-radius: .25rem;
        border: 1px solid var(--grey-main);

        cursor: pointer;
        transition: all ease-in-out .15s;
    }

    .product__item.is-selected {
        outline: 3px solid var(--main);
        border-color: transparent;
        background-color: var(--grey-light-main);
    }

    .product__item.is-selected .item__order {
        border-color: var(--active-dark-main);
        background-color: var(--background-color);
        box-shadow: none;
    }

    .product__item.is-selected .item__order:hover {
        opacity: 1;
        background-color: var(--active-dark-main);
    }

    .product__item.is-selected .item__order:hover .order__selected__icon {
        filter: brightness(0) saturate(100%) invert(99%) sepia(1%) saturate(2%) hue-rotate(132deg) brightness(110%) contrast(100%);
    }

    .product__item.is-selected .item__order .order__title {
        color: var(--active-dark-main);
    }

    .product__item.is-selected .item__order:hover .order__title {
        color: var(--background-color);
    }

	.now_ord {
		display: flex;
	}

	.sel_ord {
		display: none;
	}

	.product__item.is-selected .now_ord {
		display: none;
	}

	.product__item.is-selected .sel_ord {
		display: flex;
	}

    .product__item.is-selected .item__order .order__selected {
        width: 24px;
        height: 24px;
    }

    .product__item .item__title {
        text-align: center;
        font-size: 1.5em;
        font-weight: 600;
    }

    .product__item .item_image {
      width: 100%;
      max-width: 196px;
		  margin: 1rem 0;
    }

    .product__item .item__info {
        text-align: start;
        display: flex;
        flex-direction: column;

        width: 100%;
        margin: 1.75rem 0 1rem 0;
    }

    .product__item .item__info .info__row {
      display: flex;
      align-items: flex-end;
      gap: 1.5rem;

      width: 100%;
    }

    .product__item .item__info .info__row .row__info {
        display: flex;
        align-items: flex-end;
        gap: .15rem;
    }

    .product__item .item__info .info__value {
        font-weight: 600;
        font-size: 2em;
    }

    .product__item .item__info .info__amount {
      font-size: .75em;
      font-weight: 600;
      line-height: 70%;
      color: rgba(24, 9, 0, 0.8);
    }

    .item__info .info__discount {
      width: fit-content;
      padding: 0 .35rem;

      border-radius: 0.3rem;
      background-color: var(--active-dark-main);
    }

    .info__discount .discount__title {
      font-size: .72em;
      font-weight: 600;
      color: var(--background-color);
    }

    .item__info .info__before {
      font-weight: 600;
      font-size: 1.375em;
      text-decoration: line-through;
    }

    .item__info .info__total {
      font-weight: 500;
      font-size: .875em;
      color: var(--dark-main);
    }

    .item__recommendation {
      display: flex;
      flex-direction: column;
      gap: 0.5rem;

      width: 100%;
      margin-top: .25rem;
      margin-bottom: 2rem;
    }

    .item__recommendation .recommendation__item {
      display: flex;
      align-items: center;
      gap: .7rem;
    }

    .item__recommendation .recommendation__item .item__image {
        width: 20px;
        height: 20px;
    }

    .item__recommendation .recommendation__item .item__title {
      font-weight: 500;
      font-size: .875em;
      text-align: left;
    }

    .item__order {
/*         display: flex; */
        align-items: center;
        justify-content: center;
        gap: .5rem;

        width: 100%;
        height: 56px;
        padding: 0 1.5rem;
        margin: .5rem 0;

        border-radius: 4px;
        border: 2px solid var(--active-dark-main);
        background-color: var(--active-dark-main);

        cursor: pointer;
        transition: all ease-in-out .15s;
        animation: fadeIn ease-in-out .15s backwards;
    }

    .item__order:hover {
        opacity: .75;
    }

    .item__order:active {
        opacity: .75;
    }

    .item__order .order__selected__icon {
        width: 18px;

        filter: brightness(0) saturate(100%) invert(63%) sepia(68%) saturate(5680%) hue-rotate(258deg) brightness(84%) contrast(89%);
    }

    .item__order .order__title {
        font-size: 1.25em;
        color: var(--background-color);
    }

    .product__item .item__guarantee {
      margin-top: .5rem;
      margin-bottom: .25rem;

      font-size: .75em;
      color: var(--dark-main);
      text-transform: uppercase;
    }

    .product__item .item__cards {
        width: 100%;
        max-width: 196px;
        margin: .5rem auto 0 auto;
	}

    @media screen and (max-width: 675px) {
        .product__container {
            display: flex;
            flex-direction: column;

            width: 100%;
        }

        .product__item .item_image {
            width: 100%;
            max-width: 208px;
        }
    }
</style>

<div id="products" class="container product__container">
    <?php while ($products->have_posts()) {
    $products->the_post();
    global $product;
    $product_id = get_the_ID();

    $image = wp_get_attachment_image_src(get_post_thumbnail_id($product_id), 'single-post-thumbnail');
    $weightloss = get_field('weightloss');

    $post_date = get_the_date('YmdHis');
    $regular_price = $product->get_regular_price();

    $formatted_price = wc_price($regular_price);

    $tagsterms = wp_get_post_terms(get_the_id(), 'product_tag');

    $producttags = '';
    $prodtags = array();
    if (count($tagsterms) > 0) {
        foreach ($tagsterms as $tagterm) {
            $term_name = $tagterm->name;
            $prodtags[] = "prodtg_" . strtolower($term_name);
        }
        if (!empty($prodtags)) {
            $producttags = implode(' ', $prodtags);
        }
    }
    ?>
    <div class="product__item <?php echo $producttags; ?> <?php echo (in_array($product_id, $cart_product)) ? " active " : "" ?> prdpack_<?php echo $product_id; ?>"
         data-pack-id="<?php echo $product_id; ?>" data-orderno="<?php echo $post_date ?>"
         id="product_<?php echo $product_id; ?>" data-prdid="<?php echo $product_id; ?>"
    >
        <span class="item__title"><?php echo get_field('tooltip_text'); ?></span>
        <img class="item_image" src="<?php echo $image[0]; ?>" alt="item_image">
        <div class="item__info">
            <?php
            //echo get_field('neu_price_without_fee')
            $product_price_val = $product->get_price();

            $regular_price = $product->get_regular_price();
            $sale_price = $product->get_sale_price();
            ?>
            <div class="info__row">
                <div class="row__info">
                    <span class="info__value">
                    <?php if(!empty(get_field('pro_packung_price'))){ ?>
                    <?php echo get_field('pro_packung_price'); ?><?php echo get_woocommerce_currency_symbol(); ?>
                    <?php } ?>‎
                    </span>
                    <span class="info__amount"><?php echo __('Per<br/>pack', 'fitsmartio_en'); ?></span>
                </div>
                <div class="info__discount">
                    <span class="discount__title"><?php echo get_field('discount_text'); ?></span>
                </div>
            </div>
            <?php if(!empty($vorher_price=get_field('vorher_price'))){ ?>
            <span class="info__before"><?php echo $vorher_price; ?> <?php echo get_woocommerce_currency_symbol(); ?></span>
            <?php } ?>
            <span class="info__total"><?php echo __('In total:', 'fitsmartio_en'); ?> <?php echo $product_price_val; ?><?php echo get_woocommerce_currency_symbol(); ?></span>
        </div>
        <div class="item__recommendation">
            <div class="recommendation__item">
                <img class="item__image"
                     src="https://imagedelivery.net/u8JiH5bJQTfO_tBFRSJ5Lg/4e6595fe-6209-4c9a-03ff-a0860d3fef00/w=40,h=40"
                     alt="">
                <span class="item__title"><?php echo get_field('featured_text2'); ?></span>
            </div>
            <div class="recommendation__item">
                <img class="item__image"
                     src="https://imagedelivery.net/u8JiH5bJQTfO_tBFRSJ5Lg/4e6595fe-6209-4c9a-03ff-a0860d3fef00/w=40,h=40"
                     alt="">
                <span class="item__title"><?php echo get_field('featured_text3'); ?></span>
            </div>
        </div>
        <div class="item__order now_ord">
            <span class="order__title"><?php echo __('Order now', 'fitsmartio_en'); ?></span>
        </div>
		<div class="item__order sel_ord">
		  <svg class="order__selected__icon" xmlns="http://www.w3.org/2000/svg" width="21" height="18" viewBox="0 0 21 18" fill="none"><path d="M7.24468 11.7269L7.61317 12.1277L7.98119 11.7265L17.5584 1.28637C17.5586 1.28616 17.5588 1.28596 17.559 1.28575C17.8873 0.931058 18.322 0.740723 18.7654 0.740723C19.2091 0.740723 19.644 0.931277 19.9725 1.28637L19.9729 1.28678C20.1375 1.46434 20.2702 1.67783 20.3614 1.91594C20.4526 2.15407 20.5 2.41079 20.5 2.67094C20.5 2.93109 20.4526 3.1878 20.3614 3.42594C20.2702 3.66404 20.1375 3.87754 19.9729 4.05509L19.9715 4.0566L8.809 16.1966C8.8088 16.1968 8.8086 16.197 8.8084 16.1972C8.48198 16.549 8.05078 16.7387 7.61045 16.7407L7.6096 16.7407C7.38768 16.7421 7.16658 16.6959 6.95855 16.6035L6.75556 17.0604L6.95854 16.6035C6.75082 16.5112 6.559 16.3741 6.39521 16.1977C6.39486 16.1973 6.3945 16.1969 6.39415 16.1966L1.14923 10.4681L1.13579 10.4534L1.12123 10.4398C0.938336 10.2695 0.787283 10.0575 0.679708 9.81565L0.222871 10.0189L0.679708 9.81565C0.572112 9.57378 0.510988 9.30869 0.501349 9.0373C0.49171 8.7659 0.533838 8.496 0.624261 8.24499C0.714671 7.99401 0.850818 7.76888 1.02202 7.58268C1.19314 7.39659 1.39524 7.25367 1.6143 7.16034C1.83318 7.06707 2.06576 7.02464 2.29797 7.0344C2.5302 7.04415 2.75971 7.10601 2.97235 7.2179C3.18517 7.32988 3.37757 7.49017 3.53583 7.69115L3.54766 7.70617L3.5606 7.72025L7.24468 11.7269Z" fill="currentColor"></path></svg>
		  <span class="order__title"><?php echo __('Selected', 'fitsmartio_en'); ?></span>
		</div>
      <span class="item__guarantee"><?php echo __('Guaranteed Secure Checkout', 'fitsmartio_en'); ?></span>
        <img class="item__cards" src="https://glucofit.co/wp-content/uploads/2024/08/w320.avif" alt="item__cards">
    </div>
    <?php } ?>
</div>



