<?php
/**
 * Reviews Section block template.
 *
 * @param array $block The block settings and attributes.
 */

$page_title = get_field('page_title'); // Over 60,000 people trust us
$page_subtitle = get_field('page_subtitle'); // See what they have to say about FitSmart
$page_buy = get_field('page_buy'); // Buy now

$reviews = get_field('reviews');

$flag_url = get_field('flag_url');
$country = get_field('country');
$verified = get_field('verified');
?>

<div class="reviews__wrapper">
  <div class="container reviews__container">
    <span class="reviews__subtitle"><?php echo esc_html($page_title); ?></span>
    <span class="reviews__title"><?php echo esc_html($page_subtitle); ?></span>
    <div class="reviews__list">
      <div class="list__item">
        <div class="item__head">
          <div class="head__container">
            <img class="head__image" src="https://glucofit.co/wp-content/uploads/2024/06/Egbert.webp" alt="head__image">
            <div class="head__info">
              <span class="info__name"><?php echo esc_html($reviews['review_1']['name']); ?></span>
              <div class="info__country">
                <img class="country__flag" src="<?php echo esc_html($flag_url); ?>" alt="country__flag">
                <span class="country__nane"><?php echo esc_html($reviews['review_1']['city']); ?></span>
              </div>
            </div>
          </div>
          <div class="head__verified">
            <svg class="verified__icon" xmlns="http://www.w3.org/2000/svg" width="18" height="14" viewBox="0 0 18 14" fill="none">
              <path d="M6 10.9554L2.53462 7.48998C2.14507 7.10043 1.51344 7.0997 1.12251 7.48787C0.729631 7.87799 0.728113 8.51348 1.11961 8.90498L5.2929 13.0783C5.68342 13.4688 6.31659 13.4688 6.70711 13.0783L17.2948 2.49053C17.6843 2.10108 17.6843 1.46965 17.2948 1.0802C16.9055 0.690877 16.2743 0.690728 15.8848 1.07987L6 10.9554Z" fill="#bc4ecd"></path>
            </svg>
            <span class="verified__title"><?php echo esc_html($verified); ?></span>
          </div>
        </div>
        <div class="item__stars">
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
        </div>
        <span class="item__title"><?php echo esc_html($reviews['review_1']['title']); ?></span>
        <span class="item__text"><?php echo esc_html($reviews['review_1']['text']); ?></span>
      </div>
      <div class="list__item">
        <div class="item__head">
          <div class="head__container">
            <img class="head__image" src="https://glucofit.co/wp-content/uploads/2024/10/photo_2024-10-17-5.16.24 PM.jpeg" alt="head__image">
            <div class="head__info">
              <span class="info__name"><?php echo esc_html($reviews['review_2']['name']); ?></span>
              <div class="info__country">
                <img class="country__flag" src="<?php echo esc_html($flag_url); ?>" alt="country__flag">
                <span class="country__nane"><?php echo esc_html($reviews['review_2']['city']); ?></span>
              </div>
            </div>
          </div>
          <div class="head__verified">
            <svg class="verified__icon" xmlns="http://www.w3.org/2000/svg" width="18" height="14" viewBox="0 0 18 14" fill="none">
              <path d="M6 10.9554L2.53462 7.48998C2.14507 7.10043 1.51344 7.0997 1.12251 7.48787C0.729631 7.87799 0.728113 8.51348 1.11961 8.90498L5.2929 13.0783C5.68342 13.4688 6.31659 13.4688 6.70711 13.0783L17.2948 2.49053C17.6843 2.10108 17.6843 1.46965 17.2948 1.0802C16.9055 0.690877 16.2743 0.690728 15.8848 1.07987L6 10.9554Z" fill="#bc4ecd"></path>
            </svg>
            <span class="verified__title"><?php echo esc_html($verified); ?></span>
          </div>
        </div>
        <div class="item__stars">
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
        </div>
        <span class="item__title"><?php echo esc_html($reviews['review_2']['title']); ?></span>
        <span class="item__text"><?php echo esc_html($reviews['review_2']['text']); ?></span>
      </div>
      <div class="list__item">
        <div class="item__head">
          <div class="head__container">
            <img class="head__image" src="https://glucofit.co/wp-content/uploads/2024/10/iStock-1300972574.jpg" alt="head__image">
            <div class="head__info">
              <span class="info__name"><?php echo esc_html($reviews['review_3']['name']); ?></span>
              <div class="info__country">
                <img class="country__flag" src="<?php echo esc_html($flag_url); ?>" alt="country__flag">
                <span class="country__nane"><?php echo esc_html($reviews['review_3']['city']); ?></span>
              </div>
            </div>
          </div>
          <div class="head__verified">
            <svg class="verified__icon" xmlns="http://www.w3.org/2000/svg" width="18" height="14" viewBox="0 0 18 14" fill="none">
              <path d="M6 10.9554L2.53462 7.48998C2.14507 7.10043 1.51344 7.0997 1.12251 7.48787C0.729631 7.87799 0.728113 8.51348 1.11961 8.90498L5.2929 13.0783C5.68342 13.4688 6.31659 13.4688 6.70711 13.0783L17.2948 2.49053C17.6843 2.10108 17.6843 1.46965 17.2948 1.0802C16.9055 0.690877 16.2743 0.690728 15.8848 1.07987L6 10.9554Z" fill="#bc4ecd"></path>
            </svg>
            <span class="verified__title"><?php echo esc_html($verified); ?></span>
          </div>
        </div>
        <div class="item__stars">
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
        </div>
        <span class="item__title"><?php echo esc_html($reviews['review_3']['title']); ?></span>
        <span class="item__text"><?php echo esc_html($reviews['review_3']['text']); ?></span>
      </div>
      <div class="list__item">
        <div class="item__head">
          <div class="head__container">
            <img class="head__image" src="https://glucofit.co/wp-content/uploads/2024/10/iStock-1923382498.jpg" alt="head__image">
            <div class="head__info">
              <span class="info__name"><?php echo esc_html($reviews['review_4']['name']); ?></span>
              <div class="info__country">
                <img class="country__flag" src="<?php echo esc_html($flag_url); ?>" alt="country__flag">
                <span class="country__nane"><?php echo esc_html($reviews['review_4']['city']); ?></span>
              </div>
            </div>
          </div>
          <div class="head__verified">
            <svg class="verified__icon" xmlns="http://www.w3.org/2000/svg" width="18" height="14" viewBox="0 0 18 14" fill="none">
              <path d="M6 10.9554L2.53462 7.48998C2.14507 7.10043 1.51344 7.0997 1.12251 7.48787C0.729631 7.87799 0.728113 8.51348 1.11961 8.90498L5.2929 13.0783C5.68342 13.4688 6.31659 13.4688 6.70711 13.0783L17.2948 2.49053C17.6843 2.10108 17.6843 1.46965 17.2948 1.0802C16.9055 0.690877 16.2743 0.690728 15.8848 1.07987L6 10.9554Z" fill="#bc4ecd"></path>
            </svg>
            <span class="verified__title"><?php echo esc_html($verified); ?></span>
          </div>
        </div>
        <div class="item__stars">
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
        </div>
        <span class="item__title"><?php echo esc_html($reviews['review_4']['title']); ?></span>
        <span class="item__text"><?php echo esc_html($reviews['review_4']['text']); ?></span>
      </div>
      <div class="list__item">
        <div class="item__head">
          <div class="head__container">
            <img class="head__image" src="https://glucofit.co/wp-content/uploads/2024/05/0016-user-2.webp" alt="head__image">
            <div class="head__info">
              <span class="info__name"><?php echo esc_html($reviews['review_5']['name']); ?></span>
              <div class="info__country">
                <img class="country__flag" src="<?php echo esc_html($flag_url); ?>" alt="country__flag">
                <span class="country__nane"><?php echo esc_html($reviews['review_5']['city']); ?></span>
              </div>
            </div>
          </div>
          <div class="head__verified">
            <svg class="verified__icon" xmlns="http://www.w3.org/2000/svg" width="18" height="14" viewBox="0 0 18 14" fill="none">
              <path d="M6 10.9554L2.53462 7.48998C2.14507 7.10043 1.51344 7.0997 1.12251 7.48787C0.729631 7.87799 0.728113 8.51348 1.11961 8.90498L5.2929 13.0783C5.68342 13.4688 6.31659 13.4688 6.70711 13.0783L17.2948 2.49053C17.6843 2.10108 17.6843 1.46965 17.2948 1.0802C16.9055 0.690877 16.2743 0.690728 15.8848 1.07987L6 10.9554Z" fill="#bc4ecd"></path>
            </svg>
            <span class="verified__title"><?php echo esc_html($verified); ?></span>
          </div>
        </div>
        <div class="item__stars">
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
        </div>
        <span class="item__title"><?php echo esc_html($reviews['review_5']['title']); ?></span>
        <span class="item__text"><?php echo esc_html($reviews['review_5']['text']); ?></span>
      </div>
      <div class="list__item">
        <div class="item__head">
          <div class="head__container">
            <img class="head__image" src="https://glucofit.co/wp-content/uploads/2024/06/0004-user-2.webp" alt="head__image">
            <div class="head__info">
              <span class="info__name"><?php echo esc_html($reviews['review_6']['name']); ?></span>
              <div class="info__country">
                <img class="country__flag" src="<?php echo esc_html($flag_url); ?>" alt="country__flag">
                <span class="country__nane"><?php echo esc_html($reviews['review_6']['city']); ?></span>
              </div>
            </div>
          </div>
          <div class="head__verified">
            <svg class="verified__icon" xmlns="http://www.w3.org/2000/svg" width="18" height="14" viewBox="0 0 18 14" fill="none">
              <path d="M6 10.9554L2.53462 7.48998C2.14507 7.10043 1.51344 7.0997 1.12251 7.48787C0.729631 7.87799 0.728113 8.51348 1.11961 8.90498L5.2929 13.0783C5.68342 13.4688 6.31659 13.4688 6.70711 13.0783L17.2948 2.49053C17.6843 2.10108 17.6843 1.46965 17.2948 1.0802C16.9055 0.690877 16.2743 0.690728 15.8848 1.07987L6 10.9554Z" fill="#bc4ecd"></path>
            </svg>
            <span class="verified__title"><?php echo esc_html($verified); ?></span>
          </div>
        </div>
        <div class="item__stars">
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
          <svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
          </svg>
        </div>
        <span class="item__title"><?php echo esc_html($reviews['review_6']['title']); ?></span>
        <span class="item__text"><?php echo esc_html($reviews['review_6']['text']); ?></span>
      </div>
    </div>
    <a href="#products" class="reviews__buy">
      <span class="buy__title"><?php echo esc_html($page_buy); ?></span>
    </a>
  </div>
</div>
