<?php
include ('get_products.php');

if (is_checkout_pay_page()) return;
?>
<style>
    :root {
      --background-color: #FFFFFF;
      --background-color-secondary: #F7F9F7;
      --background-color-secondary-opacity: rgba(247, 249, 247, 0.5);

      --main: #85C98D;
      --dark-main: #20331B;
      --active-dark-main: #4ECD65;
      --active-light-main: #B8FBC3;

      --secondary: #FFF0EA;

      --grey-main: #848595;
      --grey-light-main: #F1F0F6;
      --grey-dark-main: #848595;

      --off-white: #F7F9F7;

      --warning-red: #F73D3D;
    }

  .new_checkout__wrapper {
    width: 100%;

    background-color: #fafafaff;
  }

  .new_checkout__container {
    display: flex;
    align-items: flex-start;
    gap: 1rem;

    width: 100%;
    max-width: 1280px;
    padding: 2rem 1rem;
    margin-inline: auto;
  }

.product__item {
  display: flex;
  align-items: center;
  justify-content: center;
  flex-direction: column;

  width: 100%;
  padding: 2rem;

  border-radius: 1rem;
  outline: #B7C7B7 .75px solid;
  background-color: transparent;

  transition: all ease-in-out .15s;
}
	
.new_checkout__title {
  display: flex;
  justify-content: center;
	
  width: 100%;
	
  font-weight: 600;
  font-size: 1.5rem;
  text-align: center;
}

.product__item.is-selected {
  outline: 3px solid var(--main);
  border-color: transparent;
}

.product__item.is-selected .item__order {
  border-color: transparent;
  background-color: #f09970;
  box-shadow: none;
}

.product__item.is-selected .item__order .order__title {
  color: #b67354;
}

.product__item.is-selected .item__order .order__selected {
  width: 24px;
  height: 24px;
}

.item__order.active {
    display: none;
}

.item__order.hidden {
    display: flex;
}

.product__item.is-selected .item__order.active {
    display: flex;
}

.product__item.is-selected .item__order.hidden {
    display: none;
}

.product__item .item__title {
  text-align: center;
  font-size: 2rem;
  font-weight: 600;
}

.product__item .item_image {
  width: 100%;
  max-width: 256px;
  padding: 2rem 0;
}

.product__item  .item__info {
  text-align: start;
  display: flex;
  flex-direction: column;
  gap: 0.3rem;

  width: 100%;
  margin: 1.75rem 0 1rem 0;
}

.product__item .item__info .info__value {
  font-weight: 600;
  font-size: 2rem;
}

.product__item .item__info .info__amount {
  font-size: .9rem;
  font-weight: 300;
  color: var(--grey-dark-main);
}

.item__info .info__discount {
  width: fit-content;
  margin: .5rem 0;
  padding: .25rem .5rem;

  border-radius: .3rem;
  background-color: #FFE9C8;
}

.info__discount .discount__title {
  font-size: .9rem;
  font-weight: 300;
}

.item__info .info__before {
  font-weight: 600;
  text-decoration: line-through;
  color: var(--grey-dark-main);
}

.item__info .info__total {
  font-weight: 600;
  color: var(--grey-dark-main);
}

.item__recommendation {
  display: flex;
  flex-direction: column;
  gap: 0.5rem;

  width: 100%;
  margin-bottom: 1rem;
}

.item__recommendation .recommendation__item {
  display: flex;
  align-items: center;
  gap: .7rem;
}

.item__recommendation .recommendation__item .item__image {
  width: 20px;
  height: 20px;
}

.item__recommendation .recommendation__item .item__title {
  font-weight: 600;
  font-size: 1rem;
  text-align: left;
}

.item__order {
  display: flex;
  align-items: center;
  justify-content: space-between;

  width: 100%;
  height: 56px;
  padding: 0 1.5rem;
  margin: .5rem 0;

  border-radius: 99rem;
  border: 0;
  background-color: #F68B58;
  box-shadow: -3px 3px 0 0 rgba(32, 51, 27, 0.1);

  cursor: pointer;
  transition: all ease-in-out .15s;
  animation: fadeIn ease-in-out .15s backwards;
}

.item__order:hover {
  box-shadow: -6px 6px 0 0 rgba(32, 51, 27, 0.1);
}

.item__order:active {
  background-color: #DBE9CB;
}

.item__order .order__title {
  font-weight: 600;
  font-size: 1.25rem;
  color: white;
}

.product__item .item__cards {
  width: 100%;
  max-width: 128px;
  margin: .5rem auto 0 auto;
}

@media screen and (max-width: 675px) {
  .new_checkout__container {
    flex-direction: column;
  }

  .product__item .item_image {
    width: 100%;
    max-width: 208px;
    padding: 1rem 0;
  }

  .product__item {
    padding: 1.25rem 1rem;
  }
}
</style>
<section class="new_checkout__wrapper">
  <span class="new_checkout__title"><?php echo pll__('Your personal recommendation', 'fitsmartio_en'); ?></span>	
  <div class="new_checkout__container new_checkout__product__container"> <?php while ($products->have_posts()) {
          $products->the_post();
          global $product;
          $product_id = get_the_ID();

          $image = wp_get_attachment_image_src(get_post_thumbnail_id($product_id), 'single-post-thumbnail');

		  if ($is_ab_test) {
			  $attachment_ids = $product->get_gallery_image_ids();

			  $image = wp_get_attachment_image_src( $attachment_ids[0] ?? 0, 'single-post-thumbnail' );
		  }

          $weightloss = get_field('weightloss');

          $post_date = get_the_date('YmdHis');
          $regular_price = $product->get_regular_price();
          $formatted_price = wc_price($regular_price);

          $tagsterms = wp_get_post_terms(get_the_id(), 'product_tag');

          $producttags = '';
          $prodtags = array();
          if (count($tagsterms) > 0) {
              foreach ($tagsterms as $tagterm) {
                  $term_name = $tagterm->name;
                  $prodtags[] = "prodtg_" . strtolower($term_name);
              }
              if (!empty($prodtags)) {
                  $producttags = implode(' ', $prodtags);
              }
          }
          ?>
          <div class="product__item product-block <?php echo $producttags; ?> prdpack_<?php echo $product_id; ?> <?php echo (in_array($product_id, $cart_product)) ? " is-selected " : "" ?> prdpack_<?php echo $product_id; ?>"  data-prdid="<?php echo $product_id; ?>">
              <span class="item__title"><?php echo get_field('tooltip_text'); ?></span>
              <img class="item_image" src="<?php echo $image[0]; ?>" alt="item_image">
              <div class="item__info">
                  <?php
                      //echo get_field('neu_price_without_fee')
                      $product_price_val = $product->get_price();

                      $regular_price = $product->get_regular_price();
                      $sale_price = $product->get_sale_price();
                  ?>
                <?php if(!empty(get_field('pro_packung_price'))){ ?>
                <span class="info__value"><?php echo get_field('pro_packung_price'); ?> <?php echo get_woocommerce_currency_symbol(); ?></span>
                <?php } ?>
                <span class="info__amount"><?php echo pll__('Price per pack', 'fitsmartio_en'); ?></span>
                <div class="info__discount">
                  <span class="discount__title"><?php echo get_field('discount_text'); ?></span>
                </div>
                <?php if(!empty($vorher_price=get_field('vorher_price'))){ ?>
                <span class="info__before"><?php echo $vorher_price; ?> <?php echo get_woocommerce_currency_symbol(); ?></span>
                <?php } ?>
                <span class="info__total"><?php echo pll__('Total price', 'fitsmartio_en'); ?> <?php echo $product_price_val; ?><?php echo get_woocommerce_currency_symbol(); ?></span>
              </div>
              <div class="item__recommendation">
                <div class="recommendation__item">
                  <img class="item__image"
                       src="https://imagedelivery.net/u8JiH5bJQTfO_tBFRSJ5Lg/4e6595fe-6209-4c9a-03ff-a0860d3fef00/w=40,h=40"
                       alt="">
                  <span class="item__title"><?php echo get_field('featured_text2'); ?></span>
                </div>
                <div class="recommendation__item">
                  <img class="item__image"
                       src="https://imagedelivery.net/u8JiH5bJQTfO_tBFRSJ5Lg/4e6595fe-6209-4c9a-03ff-a0860d3fef00/w=40,h=40"
                       alt="">
                  <span class="item__title"><?php echo get_field('featured_text3'); ?></span>
                </div>
              </div>
              <div class="item__order active">
                <span class="order__title" style="color: #b67354"><?php echo pll__('CHOSEN', 'fitsmartio_en') ?></span>
                <svg class="order__selected" width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path d="M7.5615 12.9078L13.9578 6.5115L13.25 5.80375L7.5615 11.4923L4.7115 8.64225L4.00375 9.35L7.5615 12.9078ZM9.00325 18C7.75875 18 6.58867 17.7638 5.493 17.2915C4.3975 16.8192 3.4445 16.1782 2.634 15.3685C1.8235 14.5588 1.18192 13.6067 0.70925 12.512C0.236417 11.4175 0 10.2479 0 9.00325C0 7.75875 0.236167 6.58867 0.7085 5.493C1.18083 4.3975 1.82183 3.4445 2.6315 2.634C3.44117 1.8235 4.39333 1.18192 5.488 0.70925C6.5825 0.236417 7.75208 0 8.99675 0C10.2413 0 11.4113 0.236167 12.507 0.708501C13.6025 1.18083 14.5555 1.82183 15.366 2.6315C16.1765 3.44117 16.8181 4.39333 17.2908 5.488C17.7636 6.5825 18 7.75208 18 8.99675C18 10.2413 17.7638 11.4113 17.2915 12.507C16.8192 13.6025 16.1782 14.5555 15.3685 15.366C14.5588 16.1765 13.6067 16.8181 12.512 17.2908C11.4175 17.7636 10.2479 18 9.00325 18ZM9 17C11.2333 17 13.125 16.225 14.675 14.675C16.225 13.125 17 11.2333 17 9C17 6.76667 16.225 4.875 14.675 3.325C13.125 1.775 11.2333 1 9 1C6.76667 1 4.875 1.775 3.325 3.325C1.775 4.875 1 6.76667 1 9C1 11.2333 1.775 13.125 3.325 14.675C4.875 16.225 6.76667 17 9 17Z" fill="#b67354"/>
                </svg>
              </div>
              <div class="item__order hidden">
                <span class="order__title"><?php echo pll__('CHOOSE', 'fitsmartio_en') ?></span>
                <svg class="order__image" width="19" height="17" viewBox="0 0 19 17" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M0.536 9.752V7.856L14.72 7.88L8.864 2.048L10.208 0.655999L18.392 8.792L10.232 16.976L8.888 15.584L14.744 9.752H0.536Z" fill="white"/>
                </svg>
              </div>
              <img class="item__cards" src="https://fitsmart.io/shop/wp-content/uploads/2024/12/payment_icons.avif" alt="item__cards">
            </div>
      <?php } ?>
  </div>
</section>
