<?php
global $woocommerce;
$cart_product = [];
$cart = $woocommerce?->cart?->get_cart() ?? [];

$checkout_id = WFACP_Common::get_id();

$ab_test_checkout_ids = [
	/* en */
	4001883,
	4001952,
	4001955,
	4001958,
	/* benl */
	4001962,
	4001965,
	4001968,
	4001971,
	/* befr */
	4001974,
	4001977,
	4001981,
	4001985,
	/* da */
	4001988,
	4001991,
	4001994,
	/* nl */
	4001997,
	4002000,
	4002004,
	4002007,
	/* fi */
	4002011,
	4002016,
	4002020,
	/* fr */
	4002024,
	4002027,
	4002030,
	4002033,
	/* de */
	4002038,
	4002041,
	4002044,
	4002047,
	/* ie */
	4002050,
	4002054,
	4002057,
	/* no */
	4002063,
	/* pt-pt */
	4002066,
	/* sv */
	4002070,
	4002073,
	4002076
];

$is_ab_test = false;

if (in_array($checkout_id, $ab_test_checkout_ids)) {
	$is_ab_test = true;
}

foreach ($cart as $cart_item_key => $cart_item) {
    array_push($cart_product, $cart_item['product_id']);
    $current_product = $cart_item['product_id'];
}

$v2_term = 'variation-2';

$tax_array = [
	[
		'taxonomy' => 'product_cat',
		'field' => 'slug',
		'terms' => $v2_term,
		'operator' => 'NOT IN' // Exclude posts from this category
	]
];

if (get_query_var("variation") == 'v2') {
	$tax_array = [
		[
			'taxonomy' => 'product_cat',
			'field' => 'slug',
			'terms' => $v2_term,
		]
	];
}

$args = [
    'post_type' => 'product',
    'posts_per_page' => -1,
    'orderby' => 'publish_date',
    'order' => 'DESC',
    'tax_query' => $tax_array
];
$products = new WP_Query($args);
