<div class="checkout-reviews-main-wrapper"> <?php

include_once(get_stylesheet_directory() . '/includes/base-code/review_functions.php');

$star_html = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="#00a473" class="rating__icon">
<path fill-rule="evenodd"
d="M10.788 3.21c.448-1.077 1.976-1.077 2.424 0l2.082 5.006 5.404.434c1.164.093 1.636 1.545.749 2.305l-4.117 3.527 1.257 5.273c.271 1.136-.964 2.033-1.96 1.425L12 18.354 7.373 21.18c-.996.608-2.231-.29-1.96-1.425l1.257-5.273-4.117-3.527c-.887-.76-.415-2.212.749-2.305l5.404-.434 2.082-5.005Z"
clip-rule="evenodd"></path>
</svg>
';

    $checkout_review = new WP_Query([
        'post_type' => 'checkout_review',
        'posts_per_page' => -1,
        'post_status' => 'publish',
    ]);
    ?>
  <style>
    .question__review {
      display: flex;
      align-items: flex-start;
      flex-direction: column;

      padding: 2rem;
      border-radius: 16px;
      background-color: #ffffff;
      box-shadow: 0px 4px 12px rgba(0, 0, 0, 0.1);
      border: none;
    }

    .question__review .review__header {
      display: flex;
      align-items: center;
      justify-content: space-between;

    }

    .question__review .review__header .header__info {
      display: flex;
      align-items: center;
      gap: .5rem;
    }

    .question__review .review__header .header__verified {
      display: flex;
      align-items: center;
      gap: .5rem;
    }

    .question__review .review__header .header__verified .verified__title {
      font-size: .9em;
      color: #00a473;
    }

    .question__review .review__header .header__info .info__avatar {
      width: 48px;
      height: 48px;

      border-radius: 12px;

      object-fit: cover;
    }

    .question__review .review__header .header__info .info__content {
      display: flex;
      flex-direction: column;
      gap: .3rem;
    }

    .question__review .review__header .header__info .info__content .content__name {
      font-size: 1.15em;
      color: #003025;
    }

    .question__review .review__header .header__info .info__content .content__country {
      display: flex;
      align-items: center;
      gap: .25rem;
    }

    .question__review .review__header .header__info .info__content .content__country .country__name {
      font-size: .9em;
      opacity: .75;
      color: #003025;
    }

    .question__review .review__header .header__info .info__content .content__country .country__flag {
      width: 18px;
      height: 12px;

      border-radius: 2px;

      object-fit: cover;
    }

    .question__review .review__rating {
      display: flex;
      align-items: center;
      gap: .25rem;

      margin: .75rem 0 .5rem 0;
    }

    .question__review .review__rating .rating__icon {
      width: 24px;
      height: 24px;
    }

    .question__review .review__rating .rating__icon svg {
      fill: #00a473;
    }

    .question__review .review__title {
      margin-bottom: .75rem;

      font-weight: 700;
      font-size: 1.35em;
      color: #003025;
    }

    .question__review .review__description {
      font-size: 1em;
      color: #003025;
    }

    .new_checkout__container.review__container {
      display: flex;
      align-items: center;
      justify-content: center;
      flex-direction: column;
      background-color: rgb(250, 248, 246);
    }

    .reviews__list {
      display: grid;
      grid-template-columns: repeat(3, 1fr);
      grid-column-gap: 16px;
      grid-row-gap: 16px;
    }

    .review__title {
      margin: 2rem 0;
      font-family: sans-serif;
      font-weight: 500;
      font-size: 2rem;
    }

    .review__section__title {
        margin: 2rem 0;
        font-family: sans-serif;
        font-weight: 700;
        font-size: 2.5rem;
		line-height: 100%;
    }
	  
	  .elementor-1005725 .elementor-element.elementor-element-75e2ce10:not(.elementor-motion-effects-element-type-background), .elementor-1005725 .elementor-element.elementor-element-75e2ce10 > .elementor-motion-effects-container > .elementor-motion-effects-layer {
		background-color: #f2f0f3 !important;
	}
	  
	  .new_checkout__container.review__container {
		  background-color: #f2f0f3 !important;
	  }
	  
	  .elementor-2047 .elementor-element.elementor-element-50458f6 img {
		  margin-top: 32px;
	  }
	  
	  .elementor-2047 .elementor-element.elementor-element-14b6f0a2 .elementor-heading-title {
		  margin-top: 32px;
		  margin-bottom: 32px;
	  }

	  @media screen and (max-width: 675px) {
		  .reviews__list {
			  display: flex;
			  flex-direction: column;
			  gap: .5rem;
		  }
	  }
  </style>
  <section class="new_checkout__wrapper">
    <div class="new_checkout__container review__container">
      <p class="review__section__title"><b><?php echo pll__('53.425 people believe it', 'fitsmartio_en'); ?></b></p>
      <p><?php echo pll__('See what some of them say about GlucoFit', 'fitsmartio_en'); ?></p>
      <div class="reviews__list">
          <?php
          if ($checkout_review->have_posts()) :
          while ($checkout_review->have_posts()) : $checkout_review->the_post();
          ?>
            <div class="question__review">
              <div class="review__header">
                <div class="header__info">
                  <img class="info__avatar"
                       src="<?php echo get_field('avatar')?>"
                       alt="">
                  <div class="info__content">
                    <span class="content__name"><?php echo get_the_title(); ?></span>
                    <div class="content__country">
                      <img class="country__flag"
                           src="<?php echo getFlagUriBySlug(get_field('flag')) ?>"
                           alt="">
                      <span class="country__name"><?php echo get_field('city') ?></span>
                    </div>
                  </div>
                </div>
              </div>
              <div class="review__rating">
              <?php printStars(get_field('rating_number'), $star_html);?>
              </div>
              <span class="review__title"><?php echo get_field('title') ?></span>
                <?php if(!empty(get_field('rating_text'))){ ?>
              <span class="review__description"><?php echo get_field('rating_text')  ?></span>
                <?php } ?>
            </div>
          <?php
          endwhile;
              wp_reset_postdata();
          endif;
          ?>
      </div>
    </div>
  </section>


