<div class="checkout-reviews-main-wrapper"> <?php

include_once(get_stylesheet_directory() . '/includes/base-code/review_functions.php');

$star_html ='<svg class="stars__icon" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.80014 0.322465L8.29254 3.34603C8.33407 3.43016 8.39543 3.50293 8.47134 3.55808C8.54725 3.61322 8.63543 3.64908 8.72828 3.66256L12.0649 4.14749C12.1718 4.16301 12.2722 4.20813 12.3548 4.27775C12.4373 4.34737 12.4988 4.4387 12.5321 4.54142C12.5655 4.64415 12.5694 4.75415 12.5435 4.859C12.5176 4.96385 12.4629 5.05935 12.3855 5.1347L9.97069 7.48816C9.83412 7.62126 9.7722 7.8128 9.80403 8.00029L10.374 11.3236C10.3923 11.43 10.3804 11.5394 10.3397 11.6394C10.299 11.7394 10.2311 11.8261 10.1438 11.8895C10.0564 11.953 9.95303 11.9907 9.84534 11.9985C9.73765 12.0063 9.62994 11.9838 9.53437 11.9335L6.54958 10.3642C6.46648 10.3206 6.37405 10.2978 6.28021 10.2978C6.18637 10.2978 6.09393 10.3206 6.01084 10.3642L3.02604 11.9335C2.93048 11.9838 2.82276 12.0063 2.71507 11.9985C2.60738 11.9907 2.50402 11.953 2.41666 11.8895C2.32931 11.8261 2.26145 11.7394 2.22075 11.6394C2.18006 11.5394 2.16816 11.43 2.18639 11.3236L2.75638 8.00029C2.77225 7.90781 2.76537 7.81286 2.73633 7.72363C2.7073 7.63441 2.65698 7.55359 2.58973 7.48816L0.174927 5.1347C0.0975565 5.05935 0.0428182 4.96385 0.0169043 4.859C-0.00900957 4.75415 -0.00506473 4.64415 0.0282926 4.54142C0.0616499 4.4387 0.123088 4.34737 0.205657 4.27775C0.288226 4.20813 0.388631 4.16301 0.495511 4.14749L3.83213 3.66256C3.92498 3.64908 4.01316 3.61322 4.08907 3.55808C4.16498 3.50293 4.22635 3.43016 4.26788 3.34603L5.76027 0.322465C5.97438 -0.107488 6.58777 -0.107488 6.80014 0.322465Z" fill="#20331B"/>
</svg>
';

    $checkout_review = new WP_Query([
        'post_type' => 'checkout_review',
        'posts_per_page' => -1,
        'post_status' => 'publish',
    ]);
?>
  <style>
      .reviews__wrapper {
          width: 100%;
          height: 100%;

          background-color: #4f4a50;
      }

      .reviews__container {
          display: flex;
          flex-direction: column;

          padding-top: 5rem;
          padding-bottom: 5rem;
      }

      .reviews__subtitle {
          display: flex;
          justify-content: center;

          margin-bottom: .5rem;

          font-weight: 700;
          font-size: 2.5em;
          color: var(--background-color);
      }

      .reviews__title {
          display: flex;
          justify-content: center;

          font-weight: 500;
          font-size: 1.2em;
          color: var(--background-color);
      }

      .reviews__list {
          display: grid;
          grid-template-columns: repeat(3, 1fr);
          gap: 1rem;

          margin-top: 5rem;
      }

      .list__item {
          display: flex;
          align-items: flex-start;
          justify-content: flex-start;
          flex-direction: column;

          width: 100%;
          padding: 1.5rem;

          border-radius: .25rem;
          background-color: var(--background-color);
      }

      .list__item .item__head {
          display: flex;
          align-items: center;
          justify-content: space-between;

          width: 100%;
      }

      .head__container {
          display: flex;
          gap: .5rem;
      }

      .head__verified {
          display: flex;
          align-items: center;
          gap: .25rem;
      }

      .head__verified .verified__icon {
          width: 14px;
      }

      .head__verified .verified__title {
          font-size: .875em;
          color: var(--active-dark-main);
      }

      .list__item .item__head .head__image {
          width: 40px;
          height: 40px;

          border-radius: 999px;

          object-fit: cover;
      }

      .list__item .item__head .head__info {
          display: flex;
          flex-direction: column;
          gap: .25rem;
      }

      .list__item .item__head .head__info .info__name {
          font-size: .9em;
      }

      .list__item .item__head .head__info .info__country {
          display: flex;
          align-items: center;
          gap: .25rem;
      }

      .list__item .item__head .head__info .info__country .country__flag {
          width: 20px;
          height: 12px;

          border-radius: 2px;

          object-fit: cover;
      }

      .list__item .item__head .head__info .info__country .country__nane {
          font-size: .875em;
      }

      .list__item .item__stars {
          display: flex;
          align-items: center;
          gap: .25rem;

          margin: .5rem 0 1rem 0;
      }

      .list__item .item__stars .stars__icon {
          width: 16px;
          height: 16px;
      }

      .list__item .item__title {
          margin-bottom: .25rem;

          font-weight: 600;
          font-size: 1.15em;
      }

      .list__item .item__text {
          font-size: .9em;
      }

      .reviews__buy {
          display: flex;
          align-items: center;
          justify-content: center;

          width: 100%;
          max-width: 256px;
          height: 56px;
          margin-inline: auto;
          margin-top: 2rem;

          border-radius: .25rem;
          border: 2px solid var(--active-dark-main);
          background-color: var(--active-dark-main);

          cursor: pointer;
          transition: all ease-in-out .15s;
      }

      .reviews__buy:hover {
          opacity: .75;
      }

      .reviews__buy .buy__title {
          font-size: 1.25em;
          color: var(--background-color);
      }

      @media screen and (max-width: 675px) {
          .reviews__list {
              display: flex;
              flex-direction: column;
          }
      }
  </style>

    <div class="reviews__wrapper">
        <div class="container reviews__container">
            <span class="reviews__subtitle"><?php echo pll__('Over 60,000 people trust us', 'fitsmartio_en'); ?></span>
            <span class="reviews__title"><?php echo pll__('See what they have to say about GlucoFit', 'fitsmartio_en'); ?></span>
            <div class="reviews__list">
                <?php
                if ($checkout_review->have_posts()) :
                while ($checkout_review->have_posts()) : $checkout_review->the_post();
                ?>

                <div class="list__item">
                    <div class="item__head">
                        <div class="head__container">
                            <img class="head__image" src="<?php echo get_field('avatar')?>" alt="head__image">
                            <div class="head__info">
                                <span class="info__name"><?php echo get_the_title(); ?></span>
                                <div class="info__country">
                                    <img class="country__flag" src="<?php echo getFlagUriBySlug(get_field('flag')) ?>" alt="country__flag">
                                    <span class="country__nane"><?php echo get_field('flag') ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="head__verified">
                            <svg class="verified__icon" xmlns="http://www.w3.org/2000/svg" width="18" height="14" viewBox="0 0 18 14" fill="none">
                                <path d="M6 10.9554L2.53462 7.48998C2.14507 7.10043 1.51344 7.0997 1.12251 7.48787C0.729631 7.87799 0.728113 8.51348 1.11961 8.90498L5.2929 13.0783C5.68342 13.4688 6.31659 13.4688 6.70711 13.0783L17.2948 2.49053C17.6843 2.10108 17.6843 1.46965 17.2948 1.0802C16.9055 0.690877 16.2743 0.690728 15.8848 1.07987L6 10.9554Z" fill="#bc4ecd"></path>
                            </svg>
                            <span class="verified__title">
                                <?php
                                echo (get_field('verified') == 'Yes') ? pll__('Verified', 'fitsmartio_en') : pll__('Not Verified', 'fitsmartio_en');
                                ?>
                            </span>
                        </div>
                    </div>
                    <div class="item__stars">
                        <?php printStars(get_field('rating_number'), $star_html);?>
                    </div>
                    <span class="item__title"><?php echo get_field('header') ?></span>
                    <span class="item__text">"<?php echo get_field('rating_text')  ?>"</span>
                </div>
                <?php
                endwhile;
                    wp_reset_postdata();
                endif;
                ?>
            </div>
            <a href="#products" class="reviews__buy">
                <span class="buy__title">Buy now</span>
            </a>
        </div>
    </div>
