<?php

// Letters language determines by checkout page, ex: Order #36923 - from UK, but received letters in DE
// Main body data

return [

// Main titles (write on green background)
//    [ // 1
//        "en" => "Thank you for shopping with us",
//        "de" => "Danke für Ihren Bestellung", //transl
//        "fr" => "Merci d'avoir magasiné avec nous",
//        "nl" => "Bedankt om bij ons te winkelen",
//    ],
//
//    [ // 1.1
//        "en" => "Thanks for your order",
//        "de" => "Danke für Ihre Bestellung",
//        "fr" => "Merci pour votre commande", // transl
//        "nl" => "bedankt voor je bestelling",
//    ],
//
    [ // 2, EN to FR, DE, NL-?
        "from" => [
            "en" => "Your order is in transit",
        ],
        "to" => [
            "de" => "Ihre Bestellung ist unterwegs",
            "fr" => "Votre commande est en transit",
            "nl" => "Uw bestelling is onderweg",   // transl
        ]
    ],


    [ // 3, EN to FR, DE, NL-?
        "from" => [
            "en" => "Your order is out for delivery",
        ],
        "to" => [
            "de" => "Ihre Bestellung ist zur Auslieferung bereit", // transl
            "fr" => "Votre commande est prête pour la livraison", // transl
            "nl" => "Uw bestelling is klaar voor bezorging", // transl
        ]
    ],

    [ // 4, EN to FR, DE, NL-?
        "from" => [
            "en" => "Your order has been delivered",
        ],
        "to" => [
            "de" => "Ihre Bestellung wurde zugestellt", // transl
            "fr" => "Votre commande a été livrée", // transl
            "nl" => "Uw bestelling is afgeleverd", // transl
        ]
    ],


    [ // 5, EN to FR, DE
        "from" => [
            "en" => "Your order has a failed delivery attempt",
        ],
        "to" => [
            "de" => "Bei Ihrer Bestellung ist ein Zustellversuch fehlgeschlagen", // transl
            "fr" => "Votre commande a une tentative de livraison échouée", // transl
            "nl" => "Uw bestelling heeft een mislukte bezorg poging", // transl
        ]
    ],

//    [ // 6
//        "en" => "Order refunded",
//        "de" => "Bestellung zurückerstattet", // transl
//        "fr" => "Commande remboursée", // transl
//        "nl" => "Bestelling terugbetaald", // transl
//    ],
//
//
//    // Greetings
//    [
//        "en" => "Hi",
//        "de" => "Hallo",
//        "fr" => "Salut", // transl
//        "nl" => "Hallo",
//    ],
//
// First phrase
//    [ // 1
//        "en" => "We have finished processing your order",
//        "de" => "wir haben deine Bestellung abgeschlossen",
//        "fr" => "Nous avons fini de traiter votre commande", // transl
//        "nl" => "We zijn klaar met het verwerken van je bestelling",
//    ],
//
    [ // 2 DE to FR, EN
        "from" =>
            [
                "de" => "Hier sind die Einzelheiten deiner Bestellung vom",
            ],
        "to" =>
            [
                "en" => "Here are the details of your order dated", // transl
                "fr" => "Voici les détails de votre commande en date", // transl
                "nl" => "Hier zijn de details van uw bestelling van", // transl
            ]
    ],
//
//
//    [ // 3.a
//      // Whole phrase - Just to let you know — we've received your order #50073, and it is now being processed
//        "en" => "Just to let you know — we've received your order",
//        "de" => "Nur um Sie darüber zu informieren — wir haben Ihre Bestellung erhalten", // transl
//        "fr" => "Juste pour vous informer — nous avons reçu votre commande", // transl
//        "nl" => "Even om u te laten weten — we hebben uw bestelling ontvangen", // transl
//    ],
//
//    [ // 3.b
//        "en" => "and it is now being processed",
//        "de" => "und sie wird jetzt bearbeitet", // transl
//        "fr" => "et il est maintenant en cours de traitement", // transl
//        "nl" => "en deze wordt nu verwerkt", // transl
//    ],
//
//    [ // 4.a
//      // Thank you very much for your order! We have received your order #50072 and will process it immediately
//        "en" => "Thank you very much for your order! We have received your order",
//        "de" => "vielen Dank für Ihre Bestellung! Wir haben Ihre Bestellung erhalten", // transl
//        "fr" => "Merci beaucoup pour votre commande! Nous avons reçu votre commande", // transl
//        "nl" => "Hartelijk dank voor uw bestelling! Wij hebben uw bestelling ontvangen", // transl
//    ],
//
//    [ // 4.b
//          "en" => "and will process it immediately",
//          "de" => "und wird es umgehend bearbeiten", // transl
//          "fr" => "et je le traiterai immédiatement", // transl
//          "nl" => "en zullen deze direct verwerken", // transl
//    ],
//
//    [
//        "en" => "Your order on FitSmart has been refunded. There are more details below for your reference",
//        "de" => "Ihre Bestellung bei FitSmart wurde erstattet. Nachfolgend finden Sie weitere Einzelheiten zur Information", // transl
//        "fr" => "Votre commande sur FitSmart a été remboursée. Voici plus de détails ci-dessous pour votre référence", // transl
//        "nl" => "Je FitSmart bestelling is terugbetaald. Hieronder vindt u meer informatie", // transl
//    ],
//
// Tracking table title DE to FR, NL, EN
    [
        "from" =>
            [
                "de" => "Verfolgen Sie Ihre Bestellung",
            ],
        "to" =>
            [
                "en" => "Track your order", // transl
                "fr" => "Suivez votre commande", // transl
                "nl" => "Volg uw bestelling", // transl
            ]
    ],

//Tracking table fields, EN to FR, DE, NL

    [
        "from" => [
            "en" => "Order Number",
        ],
        "to" => [
            "de" => "Bestellnummer", // transl
            "fr" => "Numéro de commande", // transl
            "nl" => "Bestelnummer", // transl
        ]
    ],

    [
        "from" => [
            "en" => "Tracking Number",
        ],
        "to" => [
            "de" => "Trackingnummer", // transl
            "fr" => "Numéro de suivi", // transl
            "nl" => "Volgnummer", // transl
        ]
    ],

    [
        "from" => [
            "en" => "Carrier",
        ],
        "to" => [
            "de" => "Träger", // transl
            "fr" => "Transporteur", // transl
            "nl" => "Vervoerder", // transl
        ]
    ],

    [
        "from" => [
            "en" => "Status",
        ],
        "to" => [
            "de" => "Status", // transl
            "fr" => "Statut", // transl
            "nl" => "Status", // transl
        ]
    ],

    [ // link text
        "from" => [
            "en" => "Track",
        ],
        "to" => [
            "de" => "Track", // transl
            "fr" => "Piste", // transl
            "nl" => "Volg", // transl
        ]
    ],


// Shipment statuses, EN to FR, DE
    [
        "from" => [
            "en" => "Pending",
        ],
        "to" => [
            "de" => "Ausstehend", // transl
            "fr" => "En attente", // transl
            "nl" => "In behandeling", // transl
        ]
    ],

    [
        "from" => [
            "en" => "In Transit",
        ],
        "to" => [
            "de" => "Unterwegs", // transl
            "fr" => "En transit", // transl
            "nl" => "Onderweg", // transl
        ]
    ],

    [
        "from" => [
            "en" => "Out for Delivery",
        ],
        "to" => [
            "de" => "Raus zur Lieferung", // transl
            "fr" => "En cours de livraison", // transl
            "nl" => "Word bezorgd", // transl
        ]
    ],

    [
        "from" => [
            "en" => "Delivered",
        ],
        "to" => [
            "de" => "Geliefert",
            "fr" => "Livré", // transl
            "nl" => "Afgeleverd", // transl
        ]
    ],
	
    [
        "from" => [
            "de" => "Geliefert",
        ],
        "to" => [
            "en" => "Delivered",
            "fr" => "Livré", // transl
            "nl" => "Afgeleverd", // transl
        ]
    ],

    [
        "from" => [
            "en" => "Failed Attempt",
        ],
        "to" => [
            "de" => "Fehlversuch", // transl
            "fr" => "Tentative échouée", // transl
            "nl" => "Mislukte poging", // transl
        ]
    ],


// Order table title
//
//    [
//        "en" => "[Order",
//        "de" => "[Bestellung",
//        "fr" => "[Commande",
//        "nl" => "[Bestelling",
//    ],

    [  // DE to FR, EN
        "from" =>
            [
                "de" => "(Bestellnummer",
            ],
        "to" =>
            [
                "en" => "(Order number",
                "fr" => "(Numéro de commande",
                "nl" => "(Bestelnummer",
            ]
    ],

// Months - at First phrase and Order table title, DE to EN, NL, FR

    [
        "from" => [
            "de" => "Januar",
        ],
        "to" => [
            "en" => "January",
            "fr" => "Janvier",
            "nl" => "Januari",
        ]
    ],

    [
        "from" => [
            "de" => "Februar",
        ],
        "to" => [
            "en" => "February",
            "fr" => "Février",
            "nl" => "Februari",
        ]
    ],

    [
        "from" => [
            "de" => "Marsch",
        ],
        "to" => [
            "en" => "March",
            "fr" => "Mars",
            "nl" => "Maart",
        ]
    ],

    [
        "from" => [
            "de" => "April",
        ],
        "to" => [
            "en" => "April",
            "fr" => "Avril",
            "nl" => "April",
        ]
    ],

    [
        "from" => [
            "de" => "Mai",
        ],
        "to" => [
            "en" => "May",
            "fr" => "Peut",
            "nl" => "Kunnen",
        ]
    ],

    [
        "from" => [
            "de" => "Juni",
        ],
        "to" => [
            "en" => "June",
            "fr" => "Juin",
            "nl" => "Juni",
        ]
    ],

    [
        "from" => [
            "de" => "Juli",
        ],
        "to" => [
            "en" => "July",
            "fr" => "Juillet",
            "nl" => "Juli",
        ]
    ],

    [
        "from" => [
            "de" => "August",
        ],
        "to" => [
            "en" => "August",
            "fr" => "Août",
            "nl" => "Augustus",
        ]
    ],

    [
        "from" => [
            "de" => "September",
        ],
        "to" => [
            "en" => "September",
            "fr" => "Septembre",
            "nl" => "September",
        ]
    ],

    [
        "from" => [
            "de" => "Oktober",
        ],
        "to" => [
            "en" => "October",
            "fr" => "Octobre",
            "nl" => "Oktober",
        ]
    ],

    [
        "from" => [
            "de" => "November",
        ],
        "to" => [
            "en" => "November",
            "fr" => "Novembre",
            "nl" => "November",
        ]
    ],

    [
        "from" => [
            "de" => "Dezember",
        ],
        "to" => [
            "en" => "December",
            "fr" => "Décembre",
            "nl" => "December",
        ]
    ],

// Order table fields DE to FR, EN
    [
        "from" => [
            "de" => "Produkt",
        ],
        "to" => [
            "en" => "Product",
            "fr" => "Produit", // transl
            "nl" => "Product",
        ]
    ],

    [
        "from" => [
            "de" => "Anzahl",
        ],
        "to" => [
            "en" => "Quantity",
            "fr" => "Quantité", // transl
            "nl" => "Aantal",
        ]
    ],


//
//    [
//        "en" => "Price",
//        "de" => "Preis",
//        "fr" => "Prix", // transl
//        "nl" => "Prijs",
//    ],
//
//    [
//        "en" => "Subtotal",
//        "de" => "Zwischensumme",
//        "fr" => "Sous-total", // transl
//        "nl" => "Subtotaal",
//    ],
//
//    [
//        "en" => "Payment method",
//        "de" => "Zahlungsmethode",
//        "fr" => "Mode de paiements", // transl
//        "nl" => "Betaalmethode",
//    ],
//
//    [
//        "en" => "Total",
//        "de" => "Gesamt",
//        "fr" => "Total", // transl
//        "nl" => "Totaal",
//    ],
//
//
//
// Billing address block title, DE to FR, EN
    [
        "from" => [
            "de" => "Rechnungsadresse",
        ],
        "to" => [
            "en" => "Billing address",
            "fr" => "Adresse de facturation", // transl
            "nl" => "Factuuradres",
        ]
    ],
	
// Name of countries, DE to all
    [
        "from" => [
            "de" => "Vereinigtes Königreich",
        ],
        "to" => [
            "en" => "United Kingdom",
            "fr" => "Royaume-Uni",
            "nl" => "Verenigd Koninkrijk",
        ]
    ],

    [
        "from" => [
            "de" => "Frankreich",
        ],
        "to" => [
            "en" => "France",
            "fr" => "France",
            "nl" => "Frankrijk",
        ]
    ],

    [
        "from" => [
            "de" => "Irland",
        ],
        "to" => [
            "en" => "Ireland",
            "fr" => "Irlande",
            "nl" => "Ierland",
        ]
    ],

    [
        "from" => [
            "de" => "Niederlande",
        ],
        "to" => [
            "en" => "Netherlands",
            "fr" => "Pays-Bas",
            "nl" => "Nederland",
        ]
    ],

//
//    // last phrase
//    [ // 1
//        "en" => "Thanks for shopping with us",
//        "de" => "Vielen Dank für deinen Einkauf",
//        "fr" => "Merci pour votre achat",
//        "nl" => "Bedankt voor het winkelen bij ons", // transl
//    ],
//
//    [ // 2
//        "en" => "Thanks for using fitsmart.io",
//        "de" => "Vielen Dank, dass du fitsmart.io verwendest",
//        "fr" => "Merci d'utiliser fitsmart.io", // transl
//        "nl" => "Bedankt voor het gebruiken van fitsmart.io",
//    ],
//
//    [ // 3
//        "en" => "We hope to see you again soon",
//        "de" => "Wir hoffen, Sie bald wiederzusehen", // transl
//        "fr" => "Nous espérons vous revoir bientôt", // transl
//        "nl" => "We hopen je snel weer te zien", // transl
//    ],
//
//
// Buttom DE to EN

    [
        "from" => [
            "de" => "erstellt mit",
        ],
        "to" => [
            "en" => "Built with",
            "fr" => "construit avec", // transl
            "nl" => "Gebouwd met",
        ]
    ],

];