<?php
/**
 * Ingredients Section block template.
 *
 * @param array $block The block settings and attributes.
 */

if (!is_admin()) {
    return;
}

$page_title = get_field('page_title');
$title_1 = get_field('title_1');
$text_1 = get_field('text_1');

$title_2 = get_field('title_2');
$text_2 = get_field('text_2');

$title_3 = get_field('title_3');
$text_3 = get_field('text_3');
?>

<div class="ingredients__wrapper">
  <div class="container ingredients__header">
    <span class="header__title"><?php echo esc_html($page_title); ?></span>
  </div>
  <div class="container ingredients__container">
    <div class="ingredients__item">
      <img class="item__image" src="https://images.unsplash.com/photo-1523473827533-2a64d0d36748?q=80&w=3062&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D" alt="">
      <span class="item__title"><?php echo esc_html($title_1); ?></span>
      <span class="item__subtitle"><?php echo esc_html($text_1); ?></span>
    </div>
    <div class="ingredients__item">
      <img class="item__image" src="https://images.unsplash.com/photo-1662982689227-0791c9107172?q=80&w=3348&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D" alt="">
      <span class="item__title"><?php echo esc_html($title_2); ?></span>
      <span class="item__subtitle"><?php echo esc_html($text_2); ?></span>
    </div>
    <div class="ingredients__item">
      <img class="item__image" src="https://images.unsplash.com/photo-1622798662424-f2e4f3098fdf?q=80&w=3386&auto=format&fit=crop&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D" alt="">
      <span class="item__title"><?php echo esc_html($title_3); ?></span>
      <span class="item__subtitle"><?php echo esc_html($text_3); ?></span>
    </div>
  </div>
</div>
