<?php
/**
 * Friday Banner block template.
 *
 * @param array $block The block settings and attributes.
 */

if (!is_admin()) {
    return;
}

$title = get_field('title'); // <span class="title__stroke">Black</span> Friday<br />Sale
$discount = get_field('discount'); // 45% off
$shipping = get_field('shipping'); // free shipping on<br />multi-pack orders
?>

<div class="friday__banner">
  <div class="banner__container">
    <div class="friday__content">
      <span class="content__title">
        <?php
          $allowed_tags = array(
              'span' => array(
                  'class' => array(),
              ),
              'br' => array(),
          );
          echo wp_kses($title, $allowed_tags);
        ?>
      </span>
      <div class="content__discount">
        <span class="discount__value"><?php echo esc_html($discount); ?></span>
      </div>
      <span class="content__offer">
        <?php
          $allowed_tags = array(
              'br' => array(),
          );
          echo wp_kses($shipping, $allowed_tags);
        ?>
      </span>
    </div>
    <div class="friday__image">
      <img class="image__file" src="https://glucofit.co/wp-content/uploads/2024/11/Group-1.png" alt="">
    </div>
  </div>
</div>
