jQuery(document).ready(function () {
    if (!window.AdyenCheckout) {
        console.warn("AdyenCheckout ещё не загружен");
        return;
    }

    const payment_methods = ['woosa_adyen_apple_pay', 'woosa_adyen_google_pay']

    let lastPaymentMethod = "";
    let wasShowed = []

    const calculateButtonState = (payment_method, show = false) => {
        const mainBtn = jQuery('.wfacp-order-place-btn-wrap');
        const orderPayBtn = jQuery('button#place_order');

        const mainGooglePayBtn = jQuery('.woosa_adyen_google_pay_button');
        const orderPayGooglePayBtn = jQuery('#woosa_adyen_google_pay_button');

        const mainApplePayBtn = jQuery('.adyen-checkout__applepay__button');

        if (payment_methods.includes(payment_method) && !show && !wasShowed.includes(payment_method)) {
            mainBtn && mainBtn.hide()
            orderPayBtn && orderPayBtn.hide()
        } else {
            mainBtn && mainBtn.show()
            orderPayBtn && orderPayBtn.show()

            if (show) {
                wasShowed.push(payment_method)

                switch (payment_method) {
                    case 'woosa_adyen_google_pay':
                        show && mainGooglePayBtn.hide()
                        show && orderPayGooglePayBtn.hide()
                        break;
                    case 'woosa_adyen_apple_pay':
                        show && mainApplePayBtn.hide()
                        break;
                }
            }
        }

        lastPaymentMethod = payment_method;
    }

    jQuery( 'form.checkout' ).on( 'change', 'input[name="payment_method"]', function() {
        const current_payment_method = jQuery( this ).val();

        calculateButtonState(current_payment_method)
    });

    jQuery( 'form#order_review' ).on( 'change', 'input[name="payment_method"]', function() {
        const current_payment_method = jQuery( this ).val();

        calculateButtonState(current_payment_method)
    });

    jQuery('body')
        .on('updated_checkout', function () {
            const current_payment_method = jQuery('input[name="payment_method"]:checked').val()

            calculateButtonState(current_payment_method)
        });

    const origAdyenCheckout = window.AdyenCheckout;

    window.AdyenCheckout = function (config) {
        const orig = config.onChange;

        config.onChange = (data, component) => {
            orig(data, component);

            const current_payment_method = jQuery('input[name="payment_method"]:checked').val()

            console.log('current_payment_method onChange', current_payment_method, data.isValid);

            if (!payment_methods.includes(current_payment_method)) return;

            if (data.isValid) {
                calculateButtonState(current_payment_method, data.isValid)

                setTimeout(() => {
                    const mainPurchaseBtn = jQuery('button[name="woocommerce_checkout_place_order"]')
                    const orderPayBtn = jQuery('button#place_order');

                    mainPurchaseBtn && mainPurchaseBtn.trigger('click');
                    orderPayBtn && orderPayBtn.trigger('click')
                })
            }
        }

        return origAdyenCheckout(config);
    };
});