<?php
/**
 * Footer Section block template.
 *
 * @param array $block The block settings and attributes.
 */

$logo = get_field('logo');
$link = get_field('link');

$menu = get_field('menu');

$text = get_field('text'); // This Food Supplement, is not for use by individuals under 18. Pregnant, nursing, or those with a medical condition or taking medication should consult their physician before use
$phone = get_field('phone'); // +31 85 060 3715
$email = get_field('email'); // contact@glucofit.co
?>

<footer class="footer__wrapper">
  <div class="footer__container container">
    <div class="footer__header">
      <a class="header__logo" href="<?php echo esc_html($link); ?>">
        <img class="logo__image" src="<?php echo esc_html($logo); ?>" alt="">
      </a>
      <div class="header__nav">
        <a class="nav__link" href="<?php echo esc_html($menu['item_1']['link']); ?>">
          <span class="link__title"><?php echo esc_html($menu['item_1']['title']); ?></span>
        </a>
        <a class="nav__link" href="<?php echo esc_html($menu['item_2']['link']); ?>">
          <span class="link__title"><?php echo esc_html($menu['item_2']['title']); ?></span>
        </a>
        <a class="nav__link" href="<?php echo esc_html($menu['item_3']['link']); ?>">
          <span class="link__title"><?php echo esc_html($menu['item_3']['title']); ?></span>
        </a>
        <a class="nav__link" href="<?php echo esc_html($menu['item_4']['link']); ?>">
          <span class="link__title"><?php echo esc_html($menu['item_4']['title']); ?></span>
        </a>
      </div>
    </div>
    <div class="footer__body">
      <span class="body__text"><?php echo esc_html($text); ?></span>
      <div class="body__contact">
        <a class="contact__link" href="">
          <svg class="link__image" xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
            <path d="M6.24371 7.89459C6.868 8.99239 7.7808 9.90519 8.8786 10.5295L9.46827 9.70393C9.66433 9.42953 10.0344 9.34473 10.3304 9.50639C11.2683 10.0187 12.3047 10.3301 13.3859 10.4157C13.7327 10.4431 14 10.7325 14 11.0803V14.0555C14 14.3973 13.7415 14.6837 13.4015 14.7186C13.0482 14.7549 12.6918 14.7732 12.3333 14.7732C6.62639 14.7732 2 10.1468 2 4.43986C2 4.08137 2.01828 3.725 2.05459 3.3717C2.08953 3.03169 2.37596 2.77319 2.71777 2.77319H5.69295C6.04073 2.77319 6.33009 3.04055 6.35753 3.38725C6.44311 4.46845 6.75447 5.50495 7.2668 6.44282C7.42847 6.73879 7.34367 7.10889 7.06927 7.30491L6.24371 7.89459ZM4.56283 7.45666L5.82947 6.55192C5.47031 5.77662 5.22419 4.95441 5.09818 4.10653H3.33938C3.33535 4.21741 3.33333 4.32853 3.33333 4.43986C3.33333 9.41039 7.3628 13.4399 12.3333 13.4399C12.4447 13.4399 12.5558 13.4379 12.6667 13.4338V11.675C11.8188 11.549 10.9966 11.3029 10.2213 10.9437L9.31653 12.2104C8.95053 12.0682 8.59707 11.9009 8.25827 11.7106L8.21953 11.6885C6.91313 10.9457 5.82756 9.86006 5.08467 8.55366L5.06263 8.51493C4.87233 8.17613 4.70503 7.82266 4.56283 7.45666Z" fill="white"></path>
          </svg>
          <span class="link__title"><?php echo esc_html($phone); ?></span>
        </a>
        <a class="contact__link" href="">
          <svg class="link__image" xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
            <path d="M1.99992 2.77319H13.9999C14.3681 2.77319 14.6666 3.07167 14.6666 3.43986V14.1065C14.6666 14.4747 14.3681 14.7732 13.9999 14.7732H1.99992C1.63173 14.7732 1.33325 14.4747 1.33325 14.1065V3.43986C1.33325 3.07167 1.63173 2.77319 1.99992 2.77319ZM13.3333 5.59847L8.04778 10.3319L2.66659 5.58382V13.4399H13.3333V5.59847ZM3.00756 4.10653L8.04118 8.54786L13.0006 4.10653H3.00756Z" fill="white"></path>
          </svg>
          <span class="link__title"><?php echo esc_html($email); ?></span>
        </a>
      </div>
    </div>
  </div>
</footer>
