<?php
/**
 * V5 Header Section block template.
 *
 * @param array $block The block settings and attributes.
 */

$logo = get_field('logo');
$link = get_field('link');
$order = get_field('order');
?>

<style>
* {
  scroll-behavior: smooth;
}	
	
.header__wrapper {
  width: 100%;

  background: #F9FAFB;
}	
	
.header__container {
  display: flex;
  align-items: center;
  justify-content: space-between;

  width: 100%;
  max-width: 1300px;
  height: 114px;
  margin: 0 auto;
  padding: 0 1rem;
	
  background: transparent;

  box-sizing: border-box;
  animation: fadeIn ease-in-out .25s backwards;
}

.header__logo {
  cursor: pointer;
}

.logo__image {
  max-width: 136px;
  height: 44px;
}
	
.header__order {
  display: flex;
  align-items: center;
  justify-content: center;
	
  width: 176px;
  height: 50px;
		
  border-radius: .5rem;
  background: var(--red);
	
  text-decoration: none;
	
  cursor: pointer;
  transition: all ease-in-out .15s;
}
	
.header__order:hover {
  opacity: .75;
}
	
.header__order span {
  font-weight: 600;
  font-size: 1rem;
  color: var(--white);
}
	
@media screen and (max-width: 675px) {
    .header__container {
        justify-content: center;
        height: 86px;
    }

    .header__space {
        display: none;
    }

    .header__order {
        display: none;
    }
	
	.header__logo .logo__image {
		height: 34px;
	}
}
</style>

<header class="header__wrapper">
  <div class="container header__container">
	<div class="header__space" style="width: 176px;"></div>
    <img class="logo__image" src="<?php echo esc_html($logo); ?>" alt="logo__image">
    <a href="#products" class="header__order">
	  <span><?php echo esc_html($order); ?></span>
    </a>
  </div>
</header>
