// assets/js/checkout-fix.js
(function(){
    const $ = window.jQuery;
    let checkoutReady = false;

    // 1. При загрузке страницы получаем свежие nonce
    fetch(`${CHECKOUT_URL.ajax_url}?action=refresh_checkout_nonces`, {
        credentials: 'same-origin'
    })
        .then(r => r.json())
        .then(({ success, data }) => {
            if ( ! success ) return;

            // 2. Обновляем глобальную переменную wc_checkout_params
            if ( window.wc_checkout_params ) {
                window.wc_checkout_params.update_order_review_nonce       = data.update_order_review;
                window.wc_checkout_params.process_checkout_nonce         = data.process_checkout;
            }

            // 3. Подменяем скрытые input’ы в форме
            document.querySelectorAll('input[name="security"]').forEach(el => {
                el.value = data.update_order_review;
            });
            document.querySelectorAll('input[name="woocommerce-process-checkout-nonce"]').forEach(el => {
                el.value = data.process_checkout;
            });

            // 4. Тригерим обновление
            $('body').trigger('update_checkout');
            initializeCart();
        })
        .catch(console.error);

    // Блок выбора продукта и форсированный update_checkout
    function initializeCart() {
        const blocks = document.querySelectorAll('.product-block');
        let sel = document.querySelector('.product-block.is-selected');

        if (!sel && blocks.length >= 3) {
            sel = blocks[Math.floor(blocks.length / 2)];
            sel.classList.add('is-selected');
        }
        if (!sel) return;

        const pid = sel.getAttribute('data-prdid');
        if (!pid) return;

        const fd = new FormData();
        fd.append('action', 'update_checkout');
        fd.append('cvalue', pid);

        fetch(CHECKOUT_URL.ajax_url, {
            method: 'POST',
            credentials: 'same-origin',
            body: fd
        })
            .then(r => r.json())
            .then(j => {
                if ( j && j.success==='200' ) {
                    checkoutReady = true;
                    setTimeout(() => {
                        $('body').trigger('update_checkout');
                    }, 0);
                } else {
                    console.warn('add-to-cart failed', j);
                }
            })
            .catch(console.error);
    }

    // Блок, который не даёт WooCommerce обновляться, пока checkoutReady=false
    $(document).on('update_checkout', function(e){
        if (!checkoutReady) {
            e.stopImmediatePropagation();
            return false;
        }
    });
})();
