<?php
defined( 'ABSPATH' ) || exit; //Exit if accessed directly
if ( ! class_exists( 'WFFN_Optin_Form_Field_Birthday' ) ) {
	/**
	 * This class will control all Optin Birthday mapping functionality on optin submission.
	 * Class WFFN_Optin_Form_Field_Birthday
	 */
	class WFFN_Optin_Form_Field_Birthday extends WFFN_Optin_Form_Field {

		private static $ins = null;
		public static $slug = 'optin_birthday';
		public $index = 30;

		/**
		 * WFFN_Optin_Form_Field_Birthday constructor.
		 */
		public function __construct() {
			parent::__construct();
		}

		/**
		 * @return WFFN_Optin_Form_Field_Birthday|null
		 */
		public static function get_instance() {
			if ( null === self::$ins ) {
				self::$ins = new self;
			}

			return self::$ins;
		}

		/**
		 * @return string
		 */
		public static function get_slug() {
			return self::$slug;
		}

		/**
		 * Return title of this form field
		 */
		public function get_title() {
			return __( 'Birthday', 'wp-marketing-automations-pro' );
		}

		/**
		 * @param $field_data
		 *
		 * @return string|void
		 */
		public function get_field_output( $field_data ) {
			$field_data = wp_parse_args( $field_data, $this->get_field_format() );

			$name        = $this->get_prefix() . $this::get_slug();
			$width       = isset( $field_data['width'] ) ? esc_attr( $field_data['width'] ) : '';
			$label       = isset( $field_data['label'] ) ? esc_attr( $field_data['label'] ) : '';
			$placeholder = isset( $field_data['placeholder'] ) ? esc_attr( $field_data['placeholder'] ) : '';
			$required    = isset( $field_data['required'] ) ? esc_attr( $field_data['required'] ) : false;
			$hash        = isset( $field_data['hash_key'] ) ? esc_attr( $field_data['hash_key'] ) : '';
			$value       = $this->get_default_value( $field_data );
			$class       = $this->get_input_class( $field_data );
			$max         = current_time( 'Y-m-d', 1 );
			$min         = BWFAN_PRO_Common::get_birthday_min_value();
			?>
            <style>
                .bwfac_form_field_birthday .wffn-optin-input {
                    width: 100%;
                }
            </style>
            <div class="bwfac_form_sec bwfac_form_field_birthday <?php echo esc_attr( $width ); ?>">
				<?php if ( ! empty( $label ) ) { ?>
                    <label for="wfop_id_<?php echo esc_attr( $name ) . '_' . esc_attr( $hash ); ?>"><?php echo esc_html( $label );
						echo ( $required ) ? '<span>*</span>' : ''; ?> </label>
				<?php } ?>
                <div class="wfop_input_cont">
                    <input id="wfop_id_<?php echo esc_attr( $name ) . '_' . esc_attr( $hash ); ?>" value="<?php echo esc_attr( $value ); ?>" class="<?php echo esc_attr( $class ) ?>" type="date" name="<?php echo esc_attr( $name ); ?>" placeholder="<?php echo esc_attr( $placeholder ); ?>" max="<?php echo esc_attr( $max ); ?>" <?php echo $min; ?>>
                </div>
            </div>
			<?php
		}

		/**
		 * @return array
		 */
		public function get_field_format() {
			return array(
				'width'       => 'wffn-sm-100',
				'type'        => $this::get_slug(),
				'label'       => __( 'Birthday', 'wp-marketing-automations-pro' ),
				'placeholder' => '',
				'required'    => false,
				'InputName'   => $this->get_prefix() . $this::get_slug(),
				'default'     => '',
			);
		}

		public function get_sanitized_value( $data, $field ) {
			return isset( $data[ $field['InputName'] ] ) ? wffn_clean( $data[ $field['InputName'] ] ) : '';
		}

		public function get_default_value( $field_data ) {
			if ( ! WFFN_Common::is_page_builder_editor() && true === apply_filters( 'wffn_optin_default_login_data', true, $field_data ) ) {
				global $current_user;
				if ( ! $current_user instanceof WP_User ) {
					return '';
				}

				return get_user_meta( $current_user->ID, 'bwfan_birthday_date', true );
			}

			return '';
		}
	}

	if ( class_exists( 'WFOPP_Core' ) ) {
		WFOPP_Core()->form_fields->register( WFFN_Optin_Form_Field_Birthday::get_instance() );
	}
}
