<?php

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'BWFBE_WC_BLOCKS' ) ) {

	/**
	 * EMAILBLOCKS
	 */
	#[AllowDynamicProperties]
	class BWFBE_WC_BLOCKS {

		/**
		 * __construct
		 *
		 * @return void
		 */
		public function __construct() {
			$this->loaded_shortcode();
			add_filter( 'bwfbe_localized_editor_data', [ $this, 'product_block_localized_data' ] );

		}

		public function product_block_localized_data( $data ) {

			if ( class_exists( 'WooCommerce' ) ) {
				$wcData               = [
					'placeholder_image'          => BWFCRM_Block_Editor::get_product_placeholder(),
					'product_block_attrs'        => self::product_block_attrs_data()['attrs'],
					'product_block_default_data' => self::product_block_attrs_data()['default_data'],
				];
				$data['wcblocks']     = $wcData;
				$data['is_wc_active'] = true;
			}

			return $data;
		}

		/**
		 * Plugin Loaded
		 *
		 * @return void
		 */
		public function loaded_shortcode() {

			if ( class_exists( 'WooCommerce' ) ) {
				require_once plugin_dir_path( __FILE__ ) . '/includes/class-wcblock-template-helper.php';
				$this->load_wc_order_block();
			}

		}

		public static function product_block_attrs_data() {
			$attrs = [
				'id'                => 0,
				'title'             => '{{product_title}}',
				'description'       => '{{product_description}}',
				'regularPrice'      => '{{product_price}}',
				'salePrice'         => '{{product_sale_price}}',
				'image'             => '{{product_image}}',
				'permalink'         => '{{product_url}}',
				'newTab'            => '_blank',
				'buttonText'        => __( 'Buy Now', 'wp-marketing-automations-pro' ),
				'regularPriceLabel' => __( 'Regular Price', 'wp-marketing-automations-pro' ),
				'salePriceLabel'    => __( 'Sale Price', 'wp-marketing-automations-pro' ),
			];

			$default_data = [
				'title'             => __( 'Product Title', 'wp-marketing-automations-pro' ),
				'regularPrice'      => '0.00',
				'salePrice'         => '0.00',
				'permalink'         => '',
				'description'       => __( 'Lorem ipsum is placeholder text commonly used in the graphic, print, and publishing industries for previewing layouts and visual mockups.', 'wp-marketing-automations-pro' ),
				'image'             => BWFCRM_Block_Editor::get_product_placeholder(),
				'currency'          => html_entity_decode( get_woocommerce_currency_symbol() ),
				'regularPriceLabel' => __( 'Regular Price', 'wp-marketing-automations-pro' ),
				'salePriceLabel'    => __( 'Sale Price', 'wp-marketing-automations-pro' ),
			];

			return [ 'attrs' => $attrs, 'default_data' => $default_data ];
		}

		public static function load_wc_order_block() {
			$wc_block_dir = __DIR__ . '/includes/wc-block-templates';
			foreach ( glob( $wc_block_dir . '/class-*.php' ) as $_field_filename ) {
				$file_data = pathinfo( $_field_filename );
				if ( isset( $file_data['basename'] ) && 'index.php' === $file_data['basename'] ) {
					continue;
				}
				require_once( $_field_filename );
			}
		}

	}

	new BWFBE_WC_BLOCKS();

}
