<?php
if ( ! class_exists( 'BWFBE_WC_Products_Template' ) ) {
	#[AllowDynamicProperties]
	class BWFBE_WC_Products_Template {
		/**
		 * Instance.
		 *
		 * @access private
		 * @var object Instance
		 * @since 1.2.0
		 */
		private static $instance;

		private $responsive_style = '';

		private $wrapper_selector = '';

		private $tableAttrs = '';

		private $settings = [];

		private $global_settings = [];

		public static $order;

		public $products_data = [];

		private $is_layout_x = false;

		private $currency = '';

		public static function get_instance() {
			if ( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			add_shortcode( 'bwfbe_products', [ $this, 'multi_products_block' ] );
		}


		public function multi_products_block( $atts, $content ) {

			$attributes            = json_decode( BWFCRM_Block_Editor::decode_content( $content ), true );
			$this->global_settings = BWFCRM_Block_Editor::$global_settings;

			$this->currency = get_woocommerce_currency_symbol();

			$mergetagdata = array_merge( BWFAN_Merge_Tag_Loader::get_data(), class_exists( 'BWFCRM_Core' ) ? BWFCRM_Core()->merge_tags->get_data() : [] );
			$is_crm       = false;
			if ( isset( $mergetagdata['is_crm'] ) ) {
				$is_crm = $mergetagdata['is_crm'];
			}

			$defaults = array(
				'layout'          => 'column',
				'itemCount'       => 1,
				'design'          => 'horizontal',
				'vAlignment'      => [ 'desktop' => 'center' ],
				'colWidth'        => [
					'desktop' => [
						'value' => 40,
						'unit'  => '%'
					]
				],
				'buttonText'      => 'Buy Now',
				'enableImage'     => true,
				'enableTitle'     => true,
				'enableDesc'      => true,
				'enableRegPrice'  => true,
				'enableSalePrice' => true,
				'enableButton'    => true,
				'imgWidth'        => [ 'desktop' => [ 'value' => 100, 'unit' => '%' ] ],
				'padding'         => [
					'desktop' => [
						'top'    => '10',
						'right'  => '10',
						'bottom' => '10',
						'left'   => '10',
						'unit'   => 'px'
					],
					'mobile'  => [
						'top'    => '10',
						'right'  => '10',
						'bottom' => '10',
						'left'   => '10',
						'unit'   => 'px'
					]
				],
				'btnPadding'      => [
					'desktop' => [
						'top'    => '5',
						'right'  => '16',
						'bottom' => '5',
						'left'   => '16',
						'unit'   => 'px'
					],
				],
				'btnTextLH'       => [ 'desktop' => [ 'value' => 120 ] ],
				'titleBold'       => [ 'desktop' => true ],
				'uniqueID'        => ''
			);

			$this->settings = wp_parse_args( $attributes, $defaults );


			$this->settings['classname'] = [
				'bwf-products',
				'bwf-products-' . ( $attributes['uniqueID'] ?? '' )
			];
			$this->products_data         = $this->get_product_data();

			$this->is_layout_x = 'row' === $this->settings['layout'] && 'horizontal' === $this->settings['design'];


			$this->wrapper_selector = '.bwf-products.bwf-products-' . $this->settings['uniqueID'];

			$this->tableAttrs = 'cellpadding="0" cellspacing="0" role="presentation" border="0"';

			$css    = $this->get_block_styles();
			$html   = $this->get_block_html();
			$output = BWF_Block_Editor::emogrifier_parsed_output( $css, "<table>$html</table>" );
			$output = ltrim( $output, "<table>" );
			$output = rtrim( $output, "</table>" );

			$response_style = $this->get_block_response_style();

			return BWFAN_Common::decode_merge_tags( $output . $response_style, $is_crm );
		}


		public function get_product_data() {

			if ( ! isset( $this->settings['products'] ) || empty( $this->settings['products'] ) ) {
				return [];
			}

			$products_data = [];
			$products      = $this->settings['products'];

			foreach ( $products as $product ) {
				if ( ! isset( $product['id'] ) || empty( $product['id'] ) ) {
					break;
				}
				$regular_price = '';
				$sale_price    = '';
				$data          = wc_get_product( $product['id'] );
				if ( $data->is_type( 'variable' ) ) {
					$min_price = $data->get_variation_price( 'min' );
					$max_price = $data->get_variation_price( 'max' );
					$is_range  = $min_price !== $max_price;
					if ( $is_range ) {
						$sale_price = wc_format_decimal( $min_price, 2 ) . ' - ' . $this->currency . wc_format_decimal( $max_price, 2 );
					} else {
						$sale_price    = $data->get_price();
						$regular_price = $data->get_sale_price() ? wc_format_decimal( $data->get_regular_price(), 2 ) : '';
					}
				} else if ( $data->is_type( 'grouped' ) ) {
					$children = array_filter( array_map( 'wc_get_product', $data->get_children() ), 'wc_products_array_filter_visible_grouped' );

					foreach ( $children as $child ) {
						if ( '' !== $child->get_price() ) {
							$child_prices[] = 'incl' === get_option( 'woocommerce_tax_display_shop' ) ? wc_get_price_including_tax( $child ) : wc_get_price_excluding_tax( $child );
						}
					}

					if ( ! empty( $child_prices ) ) {
						$min_price = min( $child_prices );
						$max_price = max( $child_prices );
					} else {
						$min_price = '';
						$max_price = '';
					}

					if ( $min_price !== $max_price ) {
						$sale_price = wc_format_decimal( $min_price, 2 ) . ' - ' . $this->currency . wc_format_decimal( $max_price, 2 );
					} else {
						$sale_price = $min_price;
					}
				} else {
					if ( $data->is_on_sale() ) {
						$sale_price    = $data->get_price();
						$regular_price = $data->get_regular_price();
					} else {
						$sale_price = $data->get_price();
					}
				}

				$image_url                       = wp_get_attachment_image_src( get_post_thumbnail_id( $product['id'] ), 'single-post-thumbnail' );
				$rprice                          = is_numeric( $regular_price ) ? wc_format_decimal( $regular_price, 2 ) : $regular_price;
				$sprice                          = is_numeric( $sale_price ) ? wc_format_decimal( $sale_price, 2 ) : $sale_price;
				$imageurl                        = isset( $image_url[0] ) ? $image_url[0] : BWFCRM_Block_Editor::get_product_placeholder();
				$prod_data                       = [
					'title'        => str_replace( "{{product_title}}", $data->get_name(), $product['title'] ),
					'description'  => str_replace( "{{product_description}}", $data->get_short_description(), $product['description'] ),
					'regularPrice' => str_replace( "{{product_price}}", $rprice, $product['regularPrice'] ),
					'salePrice'    => str_replace( "{{product_sale_price}}", $sprice, $product['salePrice'] ),
					'permalink'    => get_permalink( $product['id'] ),
					'image'        => str_replace( "{{product_image}}", $imageurl, $product['image'] ),
				];
				$products_data[ $product['id'] ] = $prod_data;
			}

			return $products_data;
		}

		public function get_block_html() {
			ob_start();
			$layout_class = 'column' === $this->settings['layout'] ? 'bwf-products-col-layout' : ( $this->is_layout_x ? 'bwf-products-row-x-layout' : 'bwf-products-row-y-layout' );
			?>
            <tr>
                <td class="<?php echo implode( ' ', $this->settings['classname'] ); ?>">
                    <table <?php echo is_rtl() ? 'dir="rtl"' : '' ?> class="bwf-products-container <?php echo $layout_class; ?>">
						<?php
						$count = 0;
						if ( isset( $this->settings['products'] ) ) {
							foreach ( $this->settings['products'] as $product ) {
								$product_id = $product['id'];
								$count ++;
								if ( 'row' === $this->settings['layout'] ) {
									echo $this->get_product_layout_2( $product, $product_id );
								} else {
									echo $this->get_product_layout_1( $product, $product_id, $count );
								}
							}
						}
						?>
                    </table>
                </td>
            </tr>
			<?php
			return ob_get_clean();
		}

		public function get_product_layout_1( $product, $product_id, $count ) {
			$grid_column  = (int) $this->settings['itemCount'];
			$vertical_lay = 'row' === $this->settings['layout'] && 'vertical' === $this->settings['design'];

			if ( $vertical_lay ) {
				$column_width = '100%';
			} else {
				$column_width = 3 === $grid_column ? '33.33%' : ( 2 === $grid_column ? '50%' : '100%' );
			}

			ob_start();
			echo 1 === $count ? '<tr><td class="bwf-product-grid-row"><!--[if mso | IE]><table ' . ( is_rtl() ? 'dir="rtl"' : '' ) . ' role="presentation" border="0" cellpadding="0" cellspacing="0" style="width:100%;"><tbody><tr><![endif]-->' : '';
			?>

            <!--[if mso | IE]><td class="bwf-product-wrapper <?php echo "bwf-product-col-per-" . $grid_column; ?>" style="display: inline-block; vertical-align: top; width: <?php echo sprintf( '%s', $column_width ) ?>;"><![endif]-->

            <div class="bwf-products-wrapper <?php echo "bwf-product-col-per-" . $grid_column; ?>">
                <table>
                    <tr>
						<?php
						if ( $product_id ) {
							echo $this->get_product_image( $product, $product_id );
						}
						?>
                    </tr>
                    <tr>
						<?php
						if ( $product_id ) {
							echo $this->get_product_meta( $product, $product_id );
						}
						?>
                    </tr>
                </table>
            </div>
            <!--[if mso | IE]></td><![endif]-->
			<?php
			echo $vertical_lay || $count === $grid_column ? '<!--[if mso | IE]></tr></tbody></table><![endif]--></td></tr>' : '';

			return ob_get_clean();
		}

		public function get_product_layout_2( $product, $product_id ) {
			ob_start();
			?>
            <tr>
                <td class="bwf-products-wrapper">
                    <table>
						<?php
						if ( $product_id ) {
							if ( 'vertical' === $this->settings['design'] ) {
								?>
                                <tr>
									<?php echo $this->get_product_image( $product, $product_id ); ?>
                                </tr>
                                <tr>
									<?php echo $this->get_product_meta( $product, $product_id ); ?>
                                </tr>
								<?php
							} else {
								?>
                                <tr>
									<?php
									if ( $product_id ) {
										echo $this->get_product_image( $product, $product_id );
										echo $this->get_product_meta( $product, $product_id );
									}
									?>
                                </tr>
								<?php

							}
						}
						?>
                    </table>
                </td>
            </tr>
			<?php
			return ob_get_clean();
		}

		public function get_product_image( $product, $id ) {
			if ( true !== $this->settings['enableImage'] ) {
				return '';
			}

			ob_start();
			$image       = $this->get_decoded_product_data( 'image', $product, $id );
			$title       = $this->get_decoded_product_data( 'title', $product, $id );
			$product_url = $this->get_decoded_product_data( 'permalink', $product, $id );
			$img_attrs   = [
				'src' => ! empty( $image ) ? $image : BWFCRM_Block_Editor::get_product_placeholder(),
				'alt' => $title,
			];
			if ( empty( $image ) ) {
				$img_attrs['class'] = 'bwf-product-default-img';
			}
			?>
            <td class="bwf-product-image">
                <a href="<?php echo esc_url( $product_url ); ?>">
                    <img <?php echo $this->arr_to_attr( $img_attrs ); ?> />
                </a>
            </td>
			<?php
			return ob_get_clean();
		}

		public function get_product_meta( $product, $id ) {
			$product_url = $this->get_decoded_product_data( 'permalink', $product, $id );
			$title       = $this->get_decoded_product_data( 'title', $product, $id );
			$desc        = $this->get_decoded_product_data( 'description', $product, $id );
			$reg_price   = $this->get_decoded_product_data( 'regularPrice', $product, $id );
			$sale_price  = $this->get_decoded_product_data( 'salePrice', $product, $id );
			$button_text = $this->settings['buttonText'];
			$wc_curr     = get_woocommerce_currency_symbol();
			ob_start();
			?>
            <td class="bwf-product-meta">
                <table>
					<?php if ( true === $this->settings['enableTitle'] ) : ?>
                        <tr>
                            <td class="bwf-product-title">
                                <a href="<?php echo esc_url( $product_url ); ?>">
									<?php echo $title; ?>
                                </a>
                            </td>
                        </tr>
					<?php endif; ?>

					<?php if ( true === boolval( $this->settings['enableDesc'] ) && ! empty( $desc ) ) : ?>
                        <tr>
                            <td class="bwf-product-desc"><?php echo $desc; ?></td>
                        </tr>
					<?php endif; ?>

					<?php if ( true === boolval( $this->settings['enableRegPrice'] ) && true === boolval( $this->settings['enableSalePrice'] ) ) : ?>
                        <tr>
                            <td class="bwf-product-prices">
								<?php
								if ( true === boolval( $this->settings['enableRegPrice'] ) && $reg_price ) {
									echo "<del>$wc_curr$reg_price</del> ";
								}
								if ( true === boolval( $this->settings['enableSalePrice'] ) && $sale_price ) {
									echo "<span>$wc_curr$sale_price</span> ";
								}
								?>
                            </td>
                        </tr>
					<?php endif; ?>

					<?php if ( true === boolval( $this->settings['enableButton'] ) ) : ?>
                        <tr>
                            <td class="bwf-product-btn-wrap" align="<?php echo ! $this->is_layout_x && isset( $this->settings['alignment'] ) && isset( $this->settings['alignment']['desktop'] ) ? $this->settings['alignment']['desktop'] : ( is_rtl() ? 'right' : 'left' ) ?>">
                                <table cellpadding="0" cellspacing="0" role="presentation">
                                    <tr>
                                        <td class="bwf-product-btn">
                                            <a href="<?php echo esc_url( $product_url ); ?>">
												<?php echo $this->settings['buttonText']; ?>
                                            </a>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
					<?php endif; ?>
                </table>
            </td>
			<?php
			return ob_get_clean();
		}

		public function get_block_styles() {
			ob_start();
			?>
			<?php echo $this->wrapper_selector ?> {
			<?php echo bwf_css()->getPadding( $this->settings, 'padding', 'desktop' ) . bwf_css()->getMsoPadding( $this->settings, 'padding', 'desktop' ); ?>
			<?php echo bwf_css()->getVisibilityCss( $this->settings, 'desktop' ); ?>
            }
			<?php echo $this->wrapper_selector ?> .bwf-products-container {
            width: 100%;
            }

			<?php echo $this->wrapper_selector ?> .bwf-product-grid-row {
            font-size: 0;
            }

			<?php echo $this->wrapper_selector ?> .bwf-product-wrapper {
            padding: 0 0px 32px;
            width: 100%;
            }

			<?php echo $this->wrapper_selector ?> .bwf-products-col-layout .bwf-product-col-per-1 {
            display: inline-block;
            vertical-align: top;
            width: 100%;
            box-sizing: border-box;
            }
			<?php echo $this->wrapper_selector ?> .bwf-products-col-layout .bwf-product-col-per-2 {
            display: inline-block;
            vertical-align: top;
            width: 50%;
            box-sizing: border-box;
            }
			<?php echo $this->wrapper_selector ?> .bwf-products-col-layout .bwf-product-col-per-3 {
            display: inline-block;
            vertical-align: top;
            width: 33.33%;
            box-sizing: border-box;
            }
			<?php echo $this->wrapper_selector ?> .bwf-products-row-y-layout .bwf-products-wrapper {
            display: inline-block;
            vertical-align: top;
            width: 100%;
            box-sizing: border-box;
            }
			<?php if ( 1 < $this->settings['itemCount'] ) : ?>
				<?php echo $this->wrapper_selector ?> .bwf-products-col-layout .bwf-products-wrapper:nth-child(1) .bwf-product-image,
				<?php echo $this->wrapper_selector ?> .bwf-products-col-layout .bwf-products-wrapper:nth-child(1) .bwf-product-meta {
				<?php echo is_rtl() ? 'padding-left: 6px;mso-padding-left-alt: 6px;' : 'padding-right: 6px;mso-padding-right-alt: 6px;' ?>
                }
				<?php echo $this->wrapper_selector ?> .bwf-products-col-layout .bwf-products-wrapper:nth-child(3) .bwf-product-image,
				<?php echo $this->wrapper_selector ?> .bwf-products-col-layout .bwf-products-wrapper:nth-child(3) .bwf-product-meta {
				<?php echo is_rtl() ? 'padding-right: 6px;mso-padding-right-alt: 6px;' : 'padding-left: 6px;mso-padding-left-alt: 6px;' ?>
                }
			<?php endif; ?>
			<?php echo $this->wrapper_selector ?> .bwf-products-col-layout .bwf-products-wrapper:nth-child(2) .bwf-product-image,
			<?php echo $this->wrapper_selector ?> .bwf-products-col-layout .bwf-products-wrapper:nth-child(2) .bwf-product-meta {
			<?php
			if ( 2 < $this->settings['itemCount'] ) {
				echo 'padding-left: 3px;padding-right: 3px;mso-padding-left-alt: 3px;mso-padding-right-alt: 3px;';
			} else {
				echo 'padding-left: 6px;mso-padding-left-alt: 6px;';
			}
			?>
            }
			<?php echo $this->wrapper_selector ?> .bwf-products-row-x-layout .bwf-products-wrapper,
			<?php echo $this->wrapper_selector ?> .bwf-products-row-y-layout .bwf-products-wrapper {
            padding-bottom: 16px;
            }


			<?php echo $this->wrapper_selector ?> .bwf-product-wrapper > table {
            width: 100%;
            }

			<?php echo $this->wrapper_selector ?> .bwf-product-image,
			<?php echo $this->wrapper_selector ?> .bwf-product-meta {
			<?php
			if ( $this->is_layout_x ) {
				echo 'vertical-align:' . $this->settings['vAlignment']['desktop'] . ';';
			} else {
				echo bwf_css()->textAlign( $this->settings, 'alignment', 'desktop', false, is_rtl() ? 'text-align:right;' : '' );
			}
			?>
            }


			<?php echo $this->wrapper_selector ?> .bwf-product-image {
            width: 100%;
			<?php
			if ( 'column' === $this->settings['layout'] || 'vertical' === $this->settings['design'] ) {
				?>
                padding: 0 0 16px 0;
                mso-padding-alt: 0 0 16px 0;
				<?php
			} else {
				?>
                padding: 0 12px 0px 0px;
                mso-padding-alt: 0 12px 0px 0px;
                width: <?php echo $this->settings['colWidth']['desktop']['value'] . '%;';
			}
			?>

            }
			<?php echo $this->wrapper_selector ?> .bwf-product-image img {
            width: 100%;
			<?php
			if ( 'column' === $this->settings['layout'] || 'vertical' === $this->settings['design'] ) {
				?>
                width: <?php echo $this->settings['imgWidth']['desktop']['value'] . '%;';
			}
			?>
            }
			<?php echo $this->wrapper_selector ?> .bwf-product-image .bwf-product-default-img {
            border: 1px solid #f2f2f2;
            }

			<?php echo $this->wrapper_selector ?> .bwf-product-image a {
            text-decoration: none;
            }

			<?php echo $this->wrapper_selector ?> .bwf-product-meta {
            width: 100%;
			<?php
			if ( $this->is_layout_x ) {
				?>
                width: <?php echo 100 - (int) $this->settings['colWidth']['desktop']['value'] . '%;' ?>
				<?php
			}
			?>
            }
			<?php echo $this->wrapper_selector ?> .bwf-product-meta table {
            width: 100%;
            }
			<?php echo $this->wrapper_selector ?> .bwf-product-title {
            padding-bottom: 8px;
            }
			<?php echo $this->wrapper_selector ?> .bwf-product-title a {
            word-break:break-word;
            font-size: 18px;
            font-weight: 600;
            text-decoration: none;
            color: #000;
            line-height: 1.5;
			<?php echo bwf_css()->getColor( $this->settings, 'titleColor', 'desktop' ); ?>
			<?php echo bwf_css()->getFontFamily( $this->settings ); ?>
			<?php echo bwf_css()->getFontSize( $this->settings, 'titleFont', 'desktop' ); ?>

			<?php
			if ( $this->is_layout_x ) {
				echo 'vertical-align:' . $this->settings['vAlignment']['desktop'] . ';';
			} else {
				echo bwf_css()->textAlign( $this->settings, 'alignment', 'desktop', false, is_rtl() ? 'text-align:right;' : '' );
			}
			?>
            }
			<?php echo $this->wrapper_selector ?> .bwf-product-desc {
            word-break:break-word;
            font-size: 14px;
            line-height: 1.5;
            font-weight: 400;
            color: #353030;
            padding-bottom: 10px;

			<?php echo bwf_css()->getColor( $this->settings, 'descColor', 'desktop' ); ?>
			<?php echo bwf_css()->getFontFamily( $this->settings ); ?>
			<?php echo bwf_css()->getFontSize( $this->settings, 'descFont', 'desktop' ); ?>

			<?php
			if ( $this->is_layout_x ) {
				echo 'vertical-align:' . $this->settings['vAlignment']['desktop'] . ';';
			} else {
				echo bwf_css()->textAlign( $this->settings, 'alignment', 'desktop', false, is_rtl() ? 'text-align:right;' : '' );
			}
			?>
            }
			<?php echo $this->wrapper_selector ?> .bwf-product-prices del {
            text-decoration: line-through;
            color: #353030;
            line-height: 1.5;
			<?php echo is_rtl() ? 'padding: 0 0 7px 5px;mso-padding-alt: 0 0 7px 5px;' : 'padding: 0 5px 7px 0;mso-padding-alt: 0 5px 7px 0;' ?>
            font-size: 13px;
            display: inline-block;
			<?php echo bwf_css()->getColor( $this->settings, 'regularPriceColor', 'desktop' ); ?>
			<?php echo bwf_css()->getFontFamily( $this->settings ); ?>
			<?php echo bwf_css()->getFontSize( $this->settings, 'regularPriceFont', 'desktop' ); ?>

			<?php
			if ( $this->is_layout_x ) {
				echo 'vertical-align:' . $this->settings['vAlignment']['desktop'] . ';';
			} else {
				echo bwf_css()->textAlign( $this->settings, 'alignment', 'desktop', false, is_rtl() ? 'text-align:right;' : '' );
			}
			?>
            vertical-align: bottom;
            }
			<?php echo $this->wrapper_selector ?> .bwf-product-prices span {
            text-decoration: none;
            color: #353030;
            line-height: 1.5;
            padding-left: 5px;
            padding-bottom: 10px;
            font-size: 19px;
            padding: 0 0 5px 0px;
            mso-padding-alt: 0 0 5px 5px;
            display: inline-block;
			<?php echo bwf_css()->getFontFamily( $this->settings ); ?>
			<?php echo bwf_css()->getFontSize( $this->settings, 'salePriceFont', 'desktop' ); ?>
			<?php echo bwf_css()->getColor( $this->settings, 'salePriceColor', 'desktop' ); ?>

			<?php
			if ( $this->is_layout_x ) {
				echo 'vertical-align:' . $this->settings['vAlignment']['desktop'] . ';';
			} else {
				echo bwf_css()->textAlign( $this->settings, 'alignment', 'desktop', false, is_rtl() ? 'text-align:right;' : '' );
			}
			?>
            }
			<?php echo $this->wrapper_selector ?> .bwf-product-btn-wrap > table {
            width: auto;
            border-collapse: separate;
			<?php echo bwf_css()->handleAutoWidth( $this->settings, 'btnAutoWidth', 'btnWidth', 'desktop', [ 'buttonAuto', 'buttonSize' ], false, 'value' ); ?>
            }
			<?php echo $this->wrapper_selector ?> .bwf-product-btn {
            mso-padding-alt: 5px 10px;
            text-align: center;
			<?php echo bwf_css()->getMsoPadding( $this->settings, 'btnPadding', 'desktop' ); ?>
			<?php echo bwf_css()->getBgColor( $this->settings, 'btnBgColor', 'desktop', 'buttonBackground', false, 'background:#007cba;' ); ?>
			<?php echo bwf_css()->getBorderWidth( $this->settings, 'btnBorder', 'desktop' ); ?>
			<?php echo bwf_css()->getBorderColor( $this->settings, 'btnBorder', 'desktop' ); ?>
			<?php echo bwf_css()->getBorderStyle( $this->settings, 'btnBorder', 'desktop' ); ?>
			<?php echo bwf_css()->getBorderRadius( $this->settings, 'btnBorder', 'desktop' ); ?>
            }


			<?php echo $this->wrapper_selector ?> .bwf-product-btn a {
            word-break:break-word;
            display: inline-block;
            padding: 5px 10px;
            mso-padding-alt: 0;
            text-align: center;
            font-size: 14px;
            width: auto;
            color: #fff;
            text-decoration: none;
            text-transform: none;
            margin:0;
            box-sizing: border-box;
			<?php echo bwf_css()->getFontFamily( $this->settings ); ?>
			<?php echo bwf_css()->getPadding( $this->settings, 'btnPadding', 'desktop' ); ?>
			<?php echo bwf_css()->getBgColor( $this->settings, 'btnBgColor', 'desktop', 'buttonBackground', false, 'background:#007cba;' ); ?>
			<?php echo bwf_css()->getFontSize( $this->settings, 'btnFont', 'desktop', 'buttonFont' ); ?>
			<?php echo bwf_css()->getColor( $this->settings, 'btnTextColor', 'desktop', 'buttonColor', 'color: #ffffff;' ); ?>
			<?php echo bwf_css()->getBorderRadius( $this->settings, 'btnBorder', 'desktop' ); ?>
			<?php echo bwf_css()->getLineHeight( $this->settings, 'btnTextLH', 'desktop', false ); ?>

			<?php
			if ( $this->is_layout_x ) {
				echo 'vertical-align:' . $this->settings['vAlignment']['desktop'] . ';';
			} else {
				echo bwf_css()->textAlign( $this->settings, 'alignment', 'desktop', false, is_rtl() ? 'text-align:right;' : '' );
			}
			?>
            }
			<?php
			return ob_get_clean();

		}

		public function get_block_response_style() {
			ob_start();
			?>
            <style data-id='woofunnels'>
                @media only screen and (max-width: 768px) {
                <?php echo $this->wrapper_selector ?> .bwf-product-col-per-3, <?php echo $this->wrapper_selector ?> .bwf-product-col-per-2 {
                    width: 100% !important;
                    padding-bottom: 16px;
                    padding-right: 0;
                }

                <?php echo $this->wrapper_selector ?> {
                <?php echo bwf_css()->getPadding($this->settings, 'padding', 'mobile', true); ?>
                <?php echo bwf_css()->getVisibilityCss($this->settings, 'mobile' ); ?>
                }
                <?php echo $this->wrapper_selector ?> .bwf-product-title a {
                                                      <?php echo bwf_css()->getFontSize( $this->settings, 'titleFont', 'mobile', true ); ?>
                                                      }

                <?php echo $this->wrapper_selector ?> .bwf-product-desc {
                                                      <?php echo bwf_css()->getFontSize( $this->settings, 'descFont', 'mobile', true ); ?>
                                                      }

                <?php echo $this->wrapper_selector ?> .bwf-product-prices {
                                                      <?php echo bwf_css()->getFontSize($this->settings, 'salePriceFont', 'mobile', true); ?>
                                                      }

                <?php echo $this->wrapper_selector ?> .bwf-product-prices del {
                                                      <?php echo bwf_css()->getFontSize($this->settings, 'regularPriceFont', 'mobile', true); ?>
                                                      }

                <?php echo $this->wrapper_selector ?> .bwf-product-prices span {
                                                      <?php echo bwf_css()->getFontSize($this->settings, 'salePriceFont', 'mobile', true); ?>
                                                      }

                <?php echo $this->wrapper_selector ?> .bwf-product-btn-wrap > table {
                                                      <?php echo bwf_css()->handleAutoWidth($this->settings, 'btnAutoWidth', 'btnWidth', 'mobile', ['buttonAuto', 'buttonSize'], false,'value'); ?>
                                                      }

                <?php echo $this->wrapper_selector ?> .bwf-product-btn a {
                                                      <?php echo bwf_css()->getFontSize( $this->settings, 'btnFont', 'mobile', 'buttonFont' ); ?><?php echo bwf_css()->getLineHeight( $this->settings, 'btnTextLH', 'mobile', true ); ?>
                                                      }

                <?php
				 if( $this->is_layout_x ) {
					 if( isset( $this->settings['colWidth']['mobile']['value'] ) ) {
						 echo $this->wrapper_selector ?> .bwf-product-image {
                                                                             width: <?php echo $this->settings['colWidth']['mobile']['value'] . '% !important;'; ?>
                                                                         }

                <?php }
			} else {
				if( isset( $this->settings['imgWidth']['mobile']['value'] ) ) {
					echo $this->wrapper_selector ?> .bwf-product-image img {
                                                                        width: <?php echo $this->settings['imgWidth']['mobile']['value'] . '% !important;'; ?>
                                                                    }

                <?php }
			}
			?>
                }
            </style>
			<?php
			return ob_get_clean();
		}

		public function arr_to_attr( $arr = [] ) {
			if ( empty( $arr ) ) {
				return '';
			}
			$string = '';
			foreach ( $arr as $key => $value ) {
				$string .= $key . '="' . $value . '" ';
			}

			return trim( $string );
		}


		/**
		 * Block default and common style
		 */
		public function get_default_style( $type = '' ) {
			$defaultStyle = [
				'font-size'  => 'font-size:16px;',
				'text-style' => 'margin:0;line-height: 1.5;' . bwf_css()->getFontFamily( $this->settings ),
				'color'      => bwf_css()->getColor( $this->settings, 'color', 'desktop' )
			];

			if ( ! empty( $type ) && is_string( $type ) ) {
				return $defaultStyle[ $type ];
			}

			return $defaultStyle;
		}

		private function get_decoded_product_data( $type, $product, $id ) {
			$content = '';
			$wc_data = $this->products_data[ $id ];
			switch ( $type ) {
				case 'title':
				case 'name':
					$content = str_replace( "{{product_title}}", $product['title'], $wc_data['title'] );
					break;
				case 'description':
					$content = str_replace( "{{product_description}}", $product['description'], $wc_data['description'] );
					$content = wp_strip_all_tags( $content );
					break;
				case 'regularPrice':
					$content = str_replace( "{{product_price}}", $product['regularPrice'], $wc_data['regularPrice'] );
					break;
				case 'salePrice':
					$content = str_replace( "{{product_sale_price}}", $product['salePrice'], $wc_data['salePrice'] );
					break;
				case 'permalink':
					$content = str_replace( "{{product_url}}", $product['permalink'], $wc_data['permalink'] );
					break;
				case 'image':
					$content = str_replace( "{{product_image}}", $product['image'], $wc_data['image'] );
					break;
			}

			return $content;

		}
	}
}
BWFBE_WC_Products_Template::get_instance();