<?php
/**
 * Creates minified css via PHP.
 */

if ( ! class_exists( 'Prepare_Email_Style' ) ) {

	/**
	 * Class to create a minified css output.
	 */
	#[AllowDynamicProperties]
	class Prepare_Email_Style {

		protected $_selector = '';

		protected $_style = '';

		public function set_selector( $selector = '' ) {
			// Render the css in the output string everytime the selector changes.
			if ( '' !== $this->_selector ) {
				$this->add_selector_rules_to_output();
			}
			$this->_selector = $selector;

			return $this;
		}

		public function get_style() {
			$compiled_style = $this->_style;
			$this->_style   = '';

			return $compiled_style;
		}

		private function add_selector_rules_to_output() {
			if ( ! empty( $this->_css ) ) {
				$this->prepare_selector_output();
				$selector_output = sprintf( '%1$s{%2$s}', $this->_selector_output, $this->_css );

				if ( $this->has_media_query() ) {
					$this->_media_query_output .= $selector_output;
					$this->reset_css();
				} else {
					$this->_output .= $selector_output;
				}

				// Reset the css.
				$this->reset_css();
			}

			return $this;
		}

	}
}
