<?php

if ( ! class_exists( 'BWF_Block_Editor' ) ) {

	#[AllowDynamicProperties]
	final class BWF_Block_Editor {

		/**
		 * Instance.
		 *
		 * @access private
		 * @var object Instance
		 * @since 1.2.0
		 */
		private static $instance;

		/**
		 * Initiator.
		 *
		 * @return object initialized object of class.
		 * @since 1.2.0
		 */
		public static function get_instance() {
			if ( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		/**
		 * class constructor
		 */
		public function __construct() {
			$this->load_require_files();
		}

		/**
		 * Load Common files
		 */
		public function load_require_files() {
			require_once __DIR__ . '/includes/class-css-functions.php'; // css function for blocks
		}

		public static function emogrifier_parsed_output( $css, $email_body, $return_dom = false ) {
			if ( empty( $email_body ) || empty( $css ) ) {
				return $email_body;
			}

			if ( ! BWFAN_Common::supports_emogrifier() ) {
				$email_body = '<style type="text/css">' . $css . '</style>' . $email_body;

				return $email_body;
			}

			$emogrifier_class = '\\BWF_Pelago\\Emogrifier';
			if ( ! class_exists( $emogrifier_class ) ) {
				include_once BWFAN_PLUGIN_DIR . '/libraries/class-emogrifier.php';
			}
			try {
				/** @var \BWF_Pelago\Emogrifier $emogrifier */
				$emogrifier = new $emogrifier_class( $email_body, $css );
				if ( $return_dom ) {
					$email_body = $emogrifier->emogrify();
				} else {
					$email_body = $emogrifier->emogrifyBodyContent();
				}
			} catch ( Exception $e ) {
				BWFAN_Core()->logger->log( $e->getMessage(), 'send_email_emogrifier' );
			}

			return $email_body;
		}


	}

	BWF_Block_Editor::get_instance();
}
