<?php

namespace Fitsmart\PaypalParcels;

class TrackingNoteParser
{
    public function parse(string $note, array $dataSets): bool|array
    {
        foreach ($dataSets as $dataSet) {
            if (preg_match($dataSet['tracking_number_pattern'], $note, $matchesNumber)) {
                $trackingNumber = $matchesNumber[1];

                if (preg_match($dataSet['tracking_url_pattern'], $note, $matchesUrl)) {
                    $trackingUrl = $matchesUrl[1];
                }
                return array_filter([
                    'tracking_number' => $trackingNumber,
                    'tracking_url' => $trackingUrl ?? '',
                    'carrier' => $dataSet['carrier'],
                    'carrier_name_other' => $dataSet['carrier_name_other'] ?? null,
                ]);
            }
        }
        return false;
    }
}