<?php

namespace Fitsmart\PaypalParcels;
class EnvHelper
{
    private const PAYPAL_CLIENT_ID_NAME = 'PAYPAL_CLIENT_ID';
    private const PAYPAL_SECRET_KEY_NAME = 'PAYPAL_SECRET_KEY';

    public static function getEnv(string $keyName): string
    {
        if (defined($keyName)) {
            return constant($keyName) ?? '';
        }

        $value = getenv($keyName) ?: ($_ENV[$keyName] ?? '');

        if (empty($value)) {
            error_log(sprintf('%s not set in environment.', $keyName));
        }

        return $value;
    }

    public static function getPaypalClientId(): string
    {
        return self::getEnv(self::PAYPAL_CLIENT_ID_NAME);
    }

    public static function getPaypalSecretKey(): string
    {
        return self::getEnv(self::PAYPAL_SECRET_KEY_NAME);
    }

}
