<?php

namespace Fitsmart\ParcelPanel;

class TrackingNoteParser
{
    public function parse(string $note, array $patterns): bool|array
    {
        foreach ($patterns as $courier_code => $pattern) {
            $courier_code = is_string($courier_code) ? $courier_code: null;
            if (preg_match($pattern, $note, $matches)) {
                return [
                    'tracking_number' => $matches[1],
                    'courier_code' => $courier_code,
                ];
            }
        }
        return false;
    }
}