<?php

namespace Fitsmart\ParcelPanel;
class ParcelPanelHelper
{
    private const PARCELPANEL_API_KEY_NAME = 'PARCELPANEL_API_KEY';

    public static function getApiKey(string $keyName): string
    {
        if (defined($keyName)) {
            return constant($keyName) ?? '';
        }

        $value = getenv($keyName) ?: ($_ENV[$keyName] ?? '');

        if (empty($value)) {
            error_log(sprintf('%s not set in environment.', $keyName));
        }

        return $value;
    }

    public static function getParcelKey(): string
    {
        return self::getApiKey(self::PARCELPANEL_API_KEY_NAME);
    }

}
