<?php

use Fitsmart\ParcelPanel\TrackingNoteParser;
use PHPUnit\Framework\TestCase;

class TrackingNoteParserTest extends TestCase
{
    public const COURIER_PATTERNS = \Fitsmart\ParcelPanel\Plugin::COURIER_PATTERNS;

    private array $testCases = [
        // Huboo cases
        [
            'note' => 'Huboo dispatched order - Tracking: RS564825199DE Url: https://packet.deutschepost.com/web/portal-europe/packet_traceit?barcode=RS564825199DE',
            'number' => 'RS564825199DE',
            'courier' => 'deutsche-post',
        ],
        [
            'note' => 'Huboo dispatched order - Tracking: H01HYA0037675029 Url: https://www.evri.com/track/parcel/H01HYA0037675029/details',
            'number' => 'H01HYA0037675029',
            'courier' => 'hermes-uk',
        ],
        [
            'note' => 'Huboo dispatched order - Tracking: QD574652997GB Url: https://www.royalmail.com/track-your-item#/tracking-results/QD574652997GB',
            'number' => 'QD574652997GB',
            'courier' => 'royal-mail',
        ],
        [
            'note' => 'Huboo dispatched order - Tracking: LA192766734NL Url: https://postnl.nl/tracktrace/?D=IE&B=LA192766734NL&P=K67AP90&T=C',
            'number' => 'LA192766734NL',
            'courier' => 'postnl-3s',
        ],
        [
            'note' => 'Huboo dispatched order - Tracking: HUB1080GB97156861101 Url: https://fictracking.fedex.com/?MyFICNumber=HUB1080GB97156861101',
            'number' => 'HUB1080GB97156861101',
            'courier' => 'fedex',
        ],
        [
            'note' => 'Huboo dispatched order - Tracking: 285751947317 Url: https://www.fedex.com/apps/fedextrack/index.html?tracknumbers=285751947317',
            'number' => '285751947317',
            'courier' => 'fedex',
        ],
        [
            'note' => 'Huboo dispatched order - Tracking: 01045231696737 Url: https://tracking.dpd.de/status/de_DE/parcel/01045231696737',
            'number' => '01045231696737',
            'courier' => 'dpd',
        ],
        [
            'note' => 'Huboo dispatched order - Tracking: YY28IYK6 Url: https://gls-group.eu/track/YY28IYK6',
            'number' => 'YY28IYK6',
            'courier' => 'gls',
        ],
        // ShipBob cases
        [
            'note' => 'Order has been shipped by Spring Tracked (https://mailingtechnology.com/tracking/?tn=LR514453469NL)',
            'number' => 'LR514453469NL',
            'courier' => null,
        ],
        [
            'note' => 'Order has been shipped by UPS (http://wwwapps.ups.com/WebTracking/track?track=yes&trackNums=1ZRJ70536825413991&loc=en_us)',
            'number' => '1ZRJ70536825413991',
            'courier' => null,
        ],
    ];

    public function testVariousTrackingNotes()
    {
        $parser = new TrackingNoteParser();
        foreach ($this->testCases as $case) {
            $data = $parser->parse($case['note'], self::COURIER_PATTERNS);
            $this->assertEquals($case['number'], $data['tracking_number']);
            $this->assertArrayHasKey('courier_code', $data);
            $this->assertEquals($case['courier'], $data['courier_code']);
        }
    }

}