<?php

use Fitsmart\ParcelPanel\TrackingNoteParser;
use PHPUnit\Framework\TestCase;

class TrackingNoteParserTest extends TestCase
{
    private array $patterns = [
        'hermes-uk' => '/Tracking:\\s([A-Z0-9]+)\\s.+evri\\.com/',
    ];

    public function testKnownCourierPattern()
    {
        $note = 'Huboo dispatched order – Tracking: H01HYA0038323152 Url: https://www.evri.com/track/parcel/H01HYA0038323152/details';
        $data = (new TrackingNoteParser())->parse($note, $this->patterns);
        $this->assertEquals('H01HYA0038323152', $data['tracking_number']);
        $this->assertEquals('hermes-uk', $data['courier_code']);
    }

    public function testParenthesisPattern()
    {
        $note = 'Order has been shipped by UPS (H01HYA0048844499)';
        $data = (new TrackingNoteParser())->parse($note, $this->patterns);
        $this->assertEquals('H01HYA0048844499', $data['tracking_number']);
        $this->assertArrayHasKey('courier_code', $data);
        $this->assertNull($data['courier_code']);
    }
}