<?php

namespace Fitsmart\ParcelPanel;

class TrackingNoteParser
{
    public function parse(string $note, array $patterns): bool|array
    {
        foreach ($patterns as $courier_code => $pattern) {
            if (preg_match($pattern, $note, $matches)) {
                return [
                    'tracking_number' => $matches[1],
                    'courier_code' => $courier_code,
                ];
            }
        }

        if (preg_match('/Tracking:\\s([A-Z0-9]+)\\s/', $note, $matches)) {
            return [
                'tracking_number' => $matches[1],
                'courier_code' => null,
            ];
        }
        // For ShipBob, ex. Order has been shipped by UPS (H01HYA0048844499)
        if (preg_match('/^\s*Order.*\(([A-Z0-9]+)\)\s*$/', $note, $matches)) {
            return [
                'tracking_number' => $matches[1],
                'courier_code' => null,
            ];
        }

        return false;
    }
}