<?php

namespace Fitsmart\ParcelPanel;

class Plugin
{
    public const TRACKING_NUM_PREFIX = '/Tracking:\s([A-Z0-9]+)\s/';

    public const COURIER_PATTERNS = [
        'deutsche-post' => self::TRACKING_NUM_PREFIX . '.+deutschepost\.com/',
        'hermes-uk' => self::TRACKING_NUM_PREFIX . '.+evri\.com/',
        'royal-mail' => self::TRACKING_NUM_PREFIX . '.+royalmail\.com/',
        'postnl-3s' => self::TRACKING_NUM_PREFIX . '.+postnl\.nl/',
        'fedex' => self::TRACKING_NUM_PREFIX . '.+fedex\.com/',
        'dpd' => self::TRACKING_NUM_PREFIX . '.+dpd\.de/',
        'gls' => self::TRACKING_NUM_PREFIX . '.+gls-group\.eu/',
    ];

    public function __construct(
        private ApiClient $apiClient,
        private TrackingNoteParser $parser,
    ) {
    }

    public static function bootstrap(): void
    {
        $logger = new Logger();
        $apiClient = new ApiClient($logger);
        $parser = new TrackingNoteParser();

        $plugin = new self($apiClient, $parser);
        $plugin->register_hooks();
    }

    public function register_hooks(): void
    {
        add_action('woocommerce_order_note_added', [$this, 'transfer_tracking_number_from_note_to_parcelpanel'], 10, 2);
    }

    public function transfer_tracking_number_from_note_to_parcelpanel($note_id, $order): void
    {
        $order_id = $order->get_id();
        $note_std = wc_get_order_note($note_id);
        if (!$note_std) {
            return;
        }

        $tracking_data = $this->parser->parse($note_std->content, self::COURIER_PATTERNS);
        if (!$tracking_data) {
            return;
        }

        // $tracking_std = $this->apiClient->get_tracking_by_order_id($order_id);
        // if (!empty($tracking_std->data)) {
        //     return;
        // }

        $this->apiClient->create_tracking($order_id, $tracking_data);
    }
}