<?php
declare(strict_types=1);

namespace Affilyads\WoocommerceKafkaIntegration\Includes\Cli;

use WP_CLI;
use Affilyads\WoocommerceKafkaIntegration\Includes\ClassWoocommerceKafkaHistorical;

if (defined('WP_CLI') && WP_CLI) {
    /**
     * Export WooCommerce orders to Kafka.
     *
     * ## OPTIONS
     *
     * <start>
     * : Start date (Y-m-d).
     *
     * <end>
     * : End date (Y-m-d).
     *
     * ## EXAMPLES
     *
     *     wp kafka export 2024-01-01 2024-06-01
     */
    WP_CLI::add_command('kafka export', function ( $args ) {
        [$start, $end] = $args;

        WP_CLI::log("Exporting orders {$start} → {$end}");

        $count = ClassWoocommerceKafkaHistorical::sendHistoricalData($start, $end);

        WP_CLI::success("Done. {$count} orders sent.");
    });
}
