<?php

declare(strict_types=1);

namespace woocommerce_kafka_integration\includes\topics;

abstract class Class_Woocommerce_Kafka_Abstract_Topic
{

    abstract protected function getTopicName(): string;
    abstract protected function prepareData(): array;
    abstract public function send(): void;

    private \woocommerce_kafka_integration\includes\connectors\Class_Woocommerce_Kafka_Connector $connector;
    private array $topics = [];

    public function __construct(\woocommerce_kafka_integration\includes\connectors\Class_Woocommerce_Kafka_Connector $connector)
    {
        $this->connector = $connector;

        $this->initTopic();
    }

    private function initTopic(): void
    {
        $topicNames = array_filter(array_map('trim', explode(',', $this->getTopicName())));

        foreach ($topicNames as $topicName) {
            $this->topics[] = $this->connector->getProducer()->newTopic($topicName);
        }
    }

    protected function sendData(array $preparedData): void
    {
        foreach ($this->topics as $topic) {
            $topic->produce(RD_KAFKA_PARTITION_UA, 0, json_encode($preparedData), (string) $preparedData['id'] ?? null);
        }

        $this->connector->getProducer()->flush(10000);
    }

}