<?php

declare( strict_types=1 );

namespace woocommerce_kafka_integration\includes;

use WC_Order_Query;

class Class_Woocommerce_Kafka_Historical {

    /**
     * @throws \Exception
     */
    public static function sendHistoricalData( string $startDate, string $endDate, ?string $status ): int {
        $connector = connectors\Class_Woocommerce_Kafka_Connector::getInstance();
        if ( ! $connector->isCheckedDependencies() ) {
            throw new \Exception( 'Some dependencies error! Please check debug.log' );
        }

        $topic  = new topics\Class_Woocommerce_Kafka_Order_Updated_Topic( $connector );
        $limit  = 100;
        $page   = 1;
        $sent   = 0;

        $queryArgs = [
            'type'         => 'shop_order',
            'return'       => 'objects',
            'date_created' => "{$startDate}...{$endDate}",
        ];

        if ($status !== null) {
            $queryArgs['status'] = $status;
        }

        do {
            $queryArgs['limit'] = $limit;
            $queryArgs['page']  = $page++;

            $query = new \WC_Order_Query( $queryArgs );

            $orders = $query->get_orders();

            foreach ( $orders as $order ) {
                if ($status === 'wc-checkout-draft' & !$order->get_billing_email()) {
                    continue;
                }

                $topic->send( $order->get_id(), true );
                ++$sent;
            }

            if ($page % 10 === 0) {
                wp_cache_flush();
                gc_collect_cycles();
            }
        } while ( ! empty( $orders ) );

        return $sent;
    }

    /**
     * @throws \Exception
     */
    private static function getOrders(string $startDate, string $endDate, int $limit = 1, int $offset = 0 ): object|array
    {
		$query = new WC_Order_Query( [
			'limit'  => $limit,
			'offset' => $offset,
			'type'   => 'shop_order',
            'return'       => 'ids',
			'date_created' => "$startDate...$endDate"
		] );

        return $query->get_orders();
	}

}