<?php

declare(strict_types=1);

namespace woocommerce_kafka_integration\includes\topics;

use Automattic\WooCommerce\Utilities\RestApiUtil;
use WP_REST_Request;

final class Class_Woocommerce_Kafka_Order_Created_Topic extends \woocommerce_kafka_integration\includes\topics\Class_Woocommerce_Kafka_Abstract_Topic
{

    protected function getTopicName(): string
    {
		if (defined('WP_KAFKA_ORDER_CREATED_TOPIC_NAME') && null !== constant('WP_KAFKA_ORDER_CREATED_TOPIC_NAME')) {
			return WP_KAFKA_ORDER_CREATED_TOPIC_NAME;
		}

        return 'woocommerce.order.created';
    }

    protected function prepareData(int $order_id = 0, \WC_Order $order = null): array
    {
	    $prev_user = get_current_user_id();

	    $admin_user = get_users([
		    'role'    => 'administrator',
		    'orderby' => 'ID',
		    'order'   => 'ASC',
		    'number'  => 1,
	    ]);

	    if (!empty($admin_user)) {
		    $admin_id = $admin_user[0]->ID;

		    wp_set_current_user($admin_id);
	    }

	    $response = wc_get_container()->get( RestApiUtil::class )->get_endpoint_data("/wc/v3/orders/{$order_id}");

		wp_set_current_user($prev_user);

		return $response;
    }

    public function send(int $order_id = 0): void
    {
	    $cache_key = "order_create_$order_id";

	    if (wp_cache_get($cache_key)) {
		    return;
	    }

	    $order = new \WC_Order($order_id);

	    wp_cache_set($cache_key, true, '', 5);

        $preparedData = $this->prepareData($order_id, $order);

        $this->sendData($preparedData);
    }

}