<?php

declare(strict_types=1);

namespace woocommerce_kafka_integration\includes\topics;

abstract class Class_Woocommerce_Kafka_Abstract_Topic
{

    abstract protected function getTopicName(): string;
    abstract protected function prepareData(): array;
    abstract public function send(): void;

    private \woocommerce_kafka_integration\includes\connectors\Class_Woocommerce_Kafka_Connector $connector;
    private $topic;

    public function __construct(\woocommerce_kafka_integration\includes\connectors\Class_Woocommerce_Kafka_Connector $connector)
    {
        $this->connector = $connector;

        $this->initTopic();
    }

    private function initTopic(): void
    {
        $this->topic = $this->connector->getProducer()->newTopic($this->getTopicName());
    }

    protected function sendData(array $preparedData): void
    {
        $this->topic->produce(RD_KAFKA_PARTITION_UA, 0, json_encode($preparedData), $preparedData['id'] ?? null);
    }

}