<?php

declare(strict_types=1);

namespace woocommerce_kafka_integration\includes\topics;

use Automattic\WooCommerce\Utilities\RestApiUtil;

final class Class_Woocommerce_Kafka_Order_Updated_Topic extends \woocommerce_kafka_integration\includes\topics\Class_Woocommerce_Kafka_Abstract_Topic
{

	protected const DRAFT_STATES = [
		'checkout-draft',
		'auto-draft'
	];

    protected function getTopicName(): string
    {
	    if (defined('WP_KAFKA_ORDER_UPDATED_TOPIC_NAME') && null !== constant('WP_KAFKA_ORDER_UPDATED_TOPIC_NAME')) {
		    return WP_KAFKA_ORDER_UPDATED_TOPIC_NAME;
	    }

        return 'woocommerce.order.updated';
    }

    protected function prepareData(int $order_id = 0, \WC_Order $order = null): array
    {
        static $admin_id = null;

        $prev_user = get_current_user_id();

        if ( $admin_id === null ) {
            $admin_id = (int) get_users( [
                'role'   => 'administrator',
                'fields' => 'ID',
                'number' => 1,
                'orderby'=> 'ID',
                'order'  => 'ASC',
            ] )[0] ?: 0;
        }

	    if ($admin_id) {
		    wp_set_current_user($admin_id);
	    }

	    $response = wc_get_container()->get( RestApiUtil::class )->get_endpoint_data("/wc/v3/orders/{$order_id}");

	    wp_set_current_user($prev_user);

	    return $response;
    }

    public function send(int $order_id = 0, bool $ignore_caches = false): void
    {
        $cache_key = "order_update_$order_id";

        if (!$ignore_caches) {
            if (wp_cache_get($cache_key)) {
                return;
            }

            wp_cache_set($cache_key, true, '', 5);
        }

        $preparedData = $this->prepareData($order_id);

		if (in_array($preparedData['status'], self::DRAFT_STATES)) {
			return;
		}

        $this->sendData($preparedData);
    }

}