<?php

declare( strict_types=1 );

namespace woocommerce_kafka_integration\includes;

use WC_Order_Query;

class Class_Woocommerce_Kafka_Historical {

    /**
     * @throws \Exception
     */
    public static function sendHistoricalData(string $startDate, string $endDate): int
    {
        if ( ! current_user_can( 'manage_woocommerce' ) ) {
            throw new \Exception('You dont have permission to access this page.');
		}

        $limit  = 10;
        $offset = 0;

        $orders = self::getOrders( $startDate, $endDate, $limit, $offset );

        $count = count( $orders );

        $connector = \woocommerce_kafka_integration\includes\connectors\Class_Woocommerce_Kafka_Connector::getInstance();

        if (!$connector->isCheckedDependencies()) {
            throw new \Exception('Some dependencies error! Please check debug.log');
        }

        $topic     = new \woocommerce_kafka_integration\includes\topics\Class_Woocommerce_Kafka_Order_Updated_Topic( $connector );

        while ( count( $orders ) > 0 ) {
            foreach ( $orders as $order ) {
                if (!$order instanceof \WC_Order) {
                    continue;
                }

                $topic->send( $order->get_id() );
            }

            $offset += $limit;

            $orders = self::getOrders( $startDate, $endDate, $limit, $offset );

            $count += count( $orders );
        }

        return $count;
	}

    /**
     * @throws \Exception
     */
    private static function getOrders(string $startDate, string $endDate, int $limit = 1, int $offset = 0 ): object|array
    {
		$query = new WC_Order_Query( [
			'limit'  => $limit,
			'offset' => $offset,
			'type'   => 'shop_order',
			'date_created' => "$startDate...$endDate"
		] );

        return $query->get_orders();
	}

}